/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentPropertiesExtended;
import java.io.IOException;
import java.util.Map;

public final class DeploymentExtendedInner
extends Resource {
    private DeploymentPropertiesExtended properties;
    private String type;
    private String name;
    private String id;

    public DeploymentPropertiesExtended properties() {
        return this.properties;
    }

    public DeploymentExtendedInner withProperties(DeploymentPropertiesExtended properties) {
        this.properties = properties;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DeploymentExtendedInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DeploymentExtendedInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentExtendedInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentExtendedInner)((Object)jsonReader.readObject(reader -> {
            DeploymentExtendedInner deserializedDeploymentExtendedInner = new DeploymentExtendedInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeploymentExtendedInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeploymentExtendedInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeploymentExtendedInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDeploymentExtendedInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeploymentExtendedInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentExtendedInner.properties = DeploymentPropertiesExtended.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentExtendedInner;
        }));
    }
}

