/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ChangeAttributes;
import com.azure.resourcemanager.resources.models.ChangeBase;
import com.azure.resourcemanager.resources.models.ResourceChangeType;
import java.io.IOException;
import java.util.Map;

public final class ChangeProperties
implements JsonSerializable<ChangeProperties> {
    private String targetResourceId;
    private String targetResourceType;
    private ResourceChangeType changeType;
    private ChangeAttributes changeAttributes;
    private Map<String, ChangeBase> changes;

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public ResourceChangeType changeType() {
        return this.changeType;
    }

    public ChangeAttributes changeAttributes() {
        return this.changeAttributes;
    }

    public ChangeProperties withChangeAttributes(ChangeAttributes changeAttributes) {
        this.changeAttributes = changeAttributes;
        return this;
    }

    public Map<String, ChangeBase> changes() {
        return this.changes;
    }

    public ChangeProperties withChanges(Map<String, ChangeBase> changes) {
        this.changes = changes;
        return this;
    }

    public void validate() {
        if (this.changeAttributes() != null) {
            this.changeAttributes().validate();
        }
        if (this.changes() != null) {
            this.changes().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("changeAttributes", (JsonSerializable)this.changeAttributes);
        jsonWriter.writeMapField("changes", this.changes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ChangeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ChangeProperties)jsonReader.readObject(reader -> {
            ChangeProperties deserializedChangeProperties = new ChangeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedChangeProperties.targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceType".equals(fieldName)) {
                    deserializedChangeProperties.targetResourceType = reader.getString();
                    continue;
                }
                if ("changeType".equals(fieldName)) {
                    deserializedChangeProperties.changeType = ResourceChangeType.fromString(reader.getString());
                    continue;
                }
                if ("changeAttributes".equals(fieldName)) {
                    deserializedChangeProperties.changeAttributes = ChangeAttributes.fromJson(reader);
                    continue;
                }
                if ("changes".equals(fieldName)) {
                    Map changes;
                    deserializedChangeProperties.changes = changes = reader.readMap(reader1 -> ChangeBase.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChangeProperties;
        });
    }
}

