/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.EnforcementMode;
import com.azure.resourcemanager.resources.models.NonComplianceMessage;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ParameterValuesValue;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PolicyAssignmentProperties
implements JsonSerializable<PolicyAssignmentProperties> {
    private String displayName;
    private String policyDefinitionId;
    private String definitionVersion;
    private String latestDefinitionVersion;
    private String effectiveDefinitionVersion;
    private String scope;
    private List<String> notScopes;
    private Map<String, ParameterValuesValue> parameters;
    private String description;
    private Object metadata;
    private EnforcementMode enforcementMode;
    private List<NonComplianceMessage> nonComplianceMessages;
    private List<ResourceSelector> resourceSelectors;
    private List<OverrideModel> overrides;

    public String displayName() {
        return this.displayName;
    }

    public PolicyAssignmentProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyAssignmentProperties withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String definitionVersion() {
        return this.definitionVersion;
    }

    public PolicyAssignmentProperties withDefinitionVersion(String definitionVersion) {
        this.definitionVersion = definitionVersion;
        return this;
    }

    public String latestDefinitionVersion() {
        return this.latestDefinitionVersion;
    }

    public String effectiveDefinitionVersion() {
        return this.effectiveDefinitionVersion;
    }

    public String scope() {
        return this.scope;
    }

    public List<String> notScopes() {
        return this.notScopes;
    }

    public PolicyAssignmentProperties withNotScopes(List<String> notScopes) {
        this.notScopes = notScopes;
        return this;
    }

    public Map<String, ParameterValuesValue> parameters() {
        return this.parameters;
    }

    public PolicyAssignmentProperties withParameters(Map<String, ParameterValuesValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicyAssignmentProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public EnforcementMode enforcementMode() {
        return this.enforcementMode;
    }

    public PolicyAssignmentProperties withEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
        return this;
    }

    public List<NonComplianceMessage> nonComplianceMessages() {
        return this.nonComplianceMessages;
    }

    public PolicyAssignmentProperties withNonComplianceMessages(List<NonComplianceMessage> nonComplianceMessages) {
        this.nonComplianceMessages = nonComplianceMessages;
        return this;
    }

    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    public PolicyAssignmentProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    public List<OverrideModel> overrides() {
        return this.overrides;
    }

    public PolicyAssignmentProperties withOverrides(List<OverrideModel> overrides) {
        this.overrides = overrides;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.nonComplianceMessages() != null) {
            this.nonComplianceMessages().forEach(e -> e.validate());
        }
        if (this.resourceSelectors() != null) {
            this.resourceSelectors().forEach(e -> e.validate());
        }
        if (this.overrides() != null) {
            this.overrides().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("definitionVersion", this.definitionVersion);
        jsonWriter.writeArrayField("notScopes", this.notScopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeStringField("enforcementMode", this.enforcementMode == null ? null : this.enforcementMode.toString());
        jsonWriter.writeArrayField("nonComplianceMessages", this.nonComplianceMessages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("resourceSelectors", this.resourceSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("overrides", this.overrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentProperties)jsonReader.readObject(reader -> {
            PolicyAssignmentProperties deserializedPolicyAssignmentProperties = new PolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.displayName = reader.getString();
                    continue;
                }
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("definitionVersion".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.definitionVersion = reader.getString();
                    continue;
                }
                if ("latestDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.latestDefinitionVersion = reader.getString();
                    continue;
                }
                if ("effectiveDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.effectiveDefinitionVersion = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.scope = reader.getString();
                    continue;
                }
                if ("notScopes".equals(fieldName)) {
                    List notScopes;
                    deserializedPolicyAssignmentProperties.notScopes = notScopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPolicyAssignmentProperties.parameters = parameters = reader.readMap(reader1 -> ParameterValuesValue.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.description = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.metadata = reader.readUntyped();
                    continue;
                }
                if ("enforcementMode".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.enforcementMode = EnforcementMode.fromString(reader.getString());
                    continue;
                }
                if ("nonComplianceMessages".equals(fieldName)) {
                    List nonComplianceMessages;
                    deserializedPolicyAssignmentProperties.nonComplianceMessages = nonComplianceMessages = reader.readArray(reader1 -> NonComplianceMessage.fromJson(reader1));
                    continue;
                }
                if ("resourceSelectors".equals(fieldName)) {
                    List resourceSelectors;
                    deserializedPolicyAssignmentProperties.resourceSelectors = resourceSelectors = reader.readArray(reader1 -> ResourceSelector.fromJson(reader1));
                    continue;
                }
                if ("overrides".equals(fieldName)) {
                    List overrides;
                    deserializedPolicyAssignmentProperties.overrides = overrides = reader.readArray(reader1 -> OverrideModel.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentProperties;
        });
    }
}

