/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterValuesValue;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PolicyDefinitionReference
implements JsonSerializable<PolicyDefinitionReference> {
    private String policyDefinitionId;
    private Map<String, ParameterValuesValue> parameters;
    private String policyDefinitionReferenceId;
    private List<String> groupNames;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyDefinitionReference.class);

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyDefinitionReference withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public Map<String, ParameterValuesValue> parameters() {
        return this.parameters;
    }

    public PolicyDefinitionReference withParameters(Map<String, ParameterValuesValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public PolicyDefinitionReference withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public PolicyDefinitionReference withGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
        return this;
    }

    public void validate() {
        if (this.policyDefinitionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyDefinitionId in model PolicyDefinitionReference"));
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeArrayField("groupNames", this.groupNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyDefinitionReference fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyDefinitionReference)jsonReader.readObject(reader -> {
            PolicyDefinitionReference deserializedPolicyDefinitionReference = new PolicyDefinitionReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPolicyDefinitionReference.parameters = parameters = reader.readMap(reader1 -> ParameterValuesValue.fromJson(reader1));
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("groupNames".equals(fieldName)) {
                    List groupNames;
                    deserializedPolicyDefinitionReference.groupNames = groupNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyDefinitionReference;
        });
    }
}

