/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValueMetadata;
import com.azure.resourcemanager.resources.models.ParameterType;
import java.io.IOException;
import java.util.List;

public final class ParameterDefinitionsValue
implements JsonSerializable<ParameterDefinitionsValue> {
    private ParameterType type;
    private List<Object> allowedValues;
    private Object defaultValue;
    private ParameterDefinitionsValueMetadata metadata;

    public ParameterType type() {
        return this.type;
    }

    public ParameterDefinitionsValue withType(ParameterType type) {
        this.type = type;
        return this;
    }

    public List<Object> allowedValues() {
        return this.allowedValues;
    }

    public ParameterDefinitionsValue withAllowedValues(List<Object> allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public ParameterDefinitionsValue withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ParameterDefinitionsValueMetadata metadata() {
        return this.metadata;
    }

    public ParameterDefinitionsValue withMetadata(ParameterDefinitionsValueMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("allowedValues", this.allowedValues, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("defaultValue", this.defaultValue);
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        return jsonWriter.writeEndObject();
    }

    public static ParameterDefinitionsValue fromJson(JsonReader jsonReader) throws IOException {
        return (ParameterDefinitionsValue)jsonReader.readObject(reader -> {
            ParameterDefinitionsValue deserializedParameterDefinitionsValue = new ParameterDefinitionsValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedParameterDefinitionsValue.type = ParameterType.fromString(reader.getString());
                    continue;
                }
                if ("allowedValues".equals(fieldName)) {
                    List allowedValues;
                    deserializedParameterDefinitionsValue.allowedValues = allowedValues = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedParameterDefinitionsValue.defaultValue = reader.readUntyped();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedParameterDefinitionsValue.metadata = ParameterDefinitionsValueMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedParameterDefinitionsValue;
        });
    }
}

