// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.fluent.models.PolicyExemptionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of policy exemptions. */
@Fluent
public final class PolicyExemptionListResult {
    /*
     * An array of policy exemptions.
     */
    @JsonProperty(value = "value")
    private List<PolicyExemptionInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of PolicyExemptionListResult class. */
    public PolicyExemptionListResult() {
    }

    /**
     * Get the value property: An array of policy exemptions.
     *
     * @return the value value.
     */
    public List<PolicyExemptionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of policy exemptions.
     *
     * @param value the value value to set.
     * @return the PolicyExemptionListResult object itself.
     */
    public PolicyExemptionListResult withValue(List<PolicyExemptionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
