// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Information about a tenant managing the subscription. */
@Immutable
public final class ManagedByTenant {
    /*
     * The tenant ID of the managing tenant. This is a GUID.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private String tenantId;

    /** Creates an instance of ManagedByTenant class. */
    public ManagedByTenant() {
    }

    /**
     * Get the tenantId property: The tenant ID of the managing tenant. This is a GUID.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
