// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The properties of a change. */
@Fluent
public final class ChangeProperties {
    /*
     * The fully qualified ID of the target resource that was changed
     */
    @JsonProperty(value = "targetResourceId", access = JsonProperty.Access.WRITE_ONLY)
    private String targetResourceId;

    /*
     * The namespace and type of the resource
     */
    @JsonProperty(value = "targetResourceType", access = JsonProperty.Access.WRITE_ONLY)
    private String targetResourceType;

    /*
     * The type of change that was captured in the resource
     */
    @JsonProperty(value = "changeType", access = JsonProperty.Access.WRITE_ONLY)
    private ResourceChangeType changeType;

    /*
     * Details about the change resource
     */
    @JsonProperty(value = "changeAttributes")
    private ChangeAttributes changeAttributes;

    /*
     * A dictionary with changed property name as a key and the change details
     * as the value
     */
    @JsonProperty(value = "changes")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, ChangeBase> changes;

    /**
     * Get the targetResourceId property: The fully qualified ID of the target resource that was changed.
     *
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Get the targetResourceType property: The namespace and type of the resource.
     *
     * @return the targetResourceType value.
     */
    public String targetResourceType() {
        return this.targetResourceType;
    }

    /**
     * Get the changeType property: The type of change that was captured in the resource.
     *
     * @return the changeType value.
     */
    public ResourceChangeType changeType() {
        return this.changeType;
    }

    /**
     * Get the changeAttributes property: Details about the change resource.
     *
     * @return the changeAttributes value.
     */
    public ChangeAttributes changeAttributes() {
        return this.changeAttributes;
    }

    /**
     * Set the changeAttributes property: Details about the change resource.
     *
     * @param changeAttributes the changeAttributes value to set.
     * @return the ChangeProperties object itself.
     */
    public ChangeProperties withChangeAttributes(ChangeAttributes changeAttributes) {
        this.changeAttributes = changeAttributes;
        return this;
    }

    /**
     * Get the changes property: A dictionary with changed property name as a key and the change details as the value.
     *
     * @return the changes value.
     */
    public Map<String, ChangeBase> changes() {
        return this.changes;
    }

    /**
     * Set the changes property: A dictionary with changed property name as a key and the change details as the value.
     *
     * @param changes the changes value to set.
     * @return the ChangeProperties object itself.
     */
    public ChangeProperties withChanges(Map<String, ChangeBase> changes) {
        this.changes = changes;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (changeAttributes() != null) {
            changeAttributes().validate();
        }
        if (changes() != null) {
            changes()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
    }
}
