/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.Alias;
import com.azure.resourcemanager.resources.models.ApiProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ProviderResourceType {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProviderResourceType.class);
    @JsonProperty(value="resourceType")
    private String resourceType;
    @JsonProperty(value="locations")
    private List<String> locations;
    @JsonProperty(value="aliases")
    private List<Alias> aliases;
    @JsonProperty(value="apiVersions")
    private List<String> apiVersions;
    @JsonProperty(value="defaultApiVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultApiVersion;
    @JsonProperty(value="apiProfiles", access=JsonProperty.Access.WRITE_ONLY)
    private List<ApiProfile> apiProfiles;
    @JsonProperty(value="capabilities")
    private String capabilities;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    public String resourceType() {
        return this.resourceType;
    }

    public ProviderResourceType withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ProviderResourceType withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public ProviderResourceType withAliases(List<Alias> aliases) {
        this.aliases = aliases;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public ProviderResourceType withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public String defaultApiVersion() {
        return this.defaultApiVersion;
    }

    public List<ApiProfile> apiProfiles() {
        return this.apiProfiles;
    }

    public String capabilities() {
        return this.capabilities;
    }

    public ProviderResourceType withCapabilities(String capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public ProviderResourceType withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.aliases() != null) {
            this.aliases().forEach(e -> e.validate());
        }
        if (this.apiProfiles() != null) {
            this.apiProfiles().forEach(e -> e.validate());
        }
    }
}

