/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.ProvidersClient;
import com.azure.resourcemanager.resources.fluent.models.ProviderInner;
import com.azure.resourcemanager.resources.implementation.ResourceManagementClientImpl;
import com.azure.resourcemanager.resources.models.ProviderListResult;
import reactor.core.publisher.Mono;

public final class ProvidersClientImpl
implements ProvidersClient {
    private final ClientLogger logger = new ClientLogger(ProvidersClientImpl.class);
    private final ProvidersService service;
    private final ResourceManagementClientImpl client;

    ProvidersClientImpl(ResourceManagementClientImpl client) {
        this.service = (ProvidersService)RestProxy.create(ProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ProviderInner>> unregisterWithResponseAsync(String resourceProviderNamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.unregister(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ProviderInner>> unregisterWithResponseAsync(String resourceProviderNamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.unregister(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public Mono<ProviderInner> unregisterAsync(String resourceProviderNamespace) {
        return this.unregisterWithResponseAsync(resourceProviderNamespace).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ProviderInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ProviderInner unregister(String resourceProviderNamespace) {
        return (ProviderInner)this.unregisterAsync(resourceProviderNamespace).block();
    }

    @Override
    public Response<ProviderInner> unregisterWithResponse(String resourceProviderNamespace, Context context) {
        return (Response)this.unregisterWithResponseAsync(resourceProviderNamespace, context).block();
    }

    @Override
    public Mono<Response<Void>> registerAtManagementGroupScopeWithResponseAsync(String resourceProviderNamespace, String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.registerAtManagementGroupScope(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> registerAtManagementGroupScopeWithResponseAsync(String resourceProviderNamespace, String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.registerAtManagementGroupScope(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), groupId, "application/json", context);
    }

    @Override
    public Mono<Void> registerAtManagementGroupScopeAsync(String resourceProviderNamespace, String groupId) {
        return this.registerAtManagementGroupScopeWithResponseAsync(resourceProviderNamespace, groupId).flatMap(res -> Mono.empty());
    }

    @Override
    public void registerAtManagementGroupScope(String resourceProviderNamespace, String groupId) {
        this.registerAtManagementGroupScopeAsync(resourceProviderNamespace, groupId).block();
    }

    @Override
    public Response<Void> registerAtManagementGroupScopeWithResponse(String resourceProviderNamespace, String groupId, Context context) {
        return (Response)this.registerAtManagementGroupScopeWithResponseAsync(resourceProviderNamespace, groupId, context).block();
    }

    @Override
    public Mono<Response<ProviderInner>> registerWithResponseAsync(String resourceProviderNamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.register(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ProviderInner>> registerWithResponseAsync(String resourceProviderNamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.register(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public Mono<ProviderInner> registerAsync(String resourceProviderNamespace) {
        return this.registerWithResponseAsync(resourceProviderNamespace).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ProviderInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ProviderInner register(String resourceProviderNamespace) {
        return (ProviderInner)this.registerAsync(resourceProviderNamespace).block();
    }

    @Override
    public Response<ProviderInner> registerWithResponse(String resourceProviderNamespace, Context context) {
        return (Response)this.registerWithResponseAsync(resourceProviderNamespace, context).block();
    }

    private Mono<PagedResponse<ProviderInner>> listSinglePageAsync(Integer top, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), top, expand, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ProviderInner>> listSinglePageAsync(Integer top, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), top, expand, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ProviderInner> listAsync(Integer top, String expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ProviderInner> listAsync() {
        Integer top = null;
        String expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ProviderInner> listAsync(Integer top, String expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ProviderInner> list() {
        Integer top = null;
        String expand = null;
        return new PagedIterable(this.listAsync(top, expand));
    }

    @Override
    public PagedIterable<ProviderInner> list(Integer top, String expand, Context context) {
        return new PagedIterable(this.listAsync(top, expand, context));
    }

    private Mono<PagedResponse<ProviderInner>> listAtTenantScopeSinglePageAsync(Integer top, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtTenantScope(this.client.getEndpoint(), top, expand, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ProviderInner>> listAtTenantScopeSinglePageAsync(Integer top, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtTenantScope(this.client.getEndpoint(), top, expand, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ProviderInner> listAtTenantScopeAsync(Integer top, String expand) {
        return new PagedFlux(() -> this.listAtTenantScopeSinglePageAsync(top, expand), nextLink -> this.listAtTenantScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ProviderInner> listAtTenantScopeAsync() {
        Integer top = null;
        String expand = null;
        return new PagedFlux(() -> this.listAtTenantScopeSinglePageAsync(top, expand), nextLink -> this.listAtTenantScopeNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ProviderInner> listAtTenantScopeAsync(Integer top, String expand, Context context) {
        return new PagedFlux(() -> this.listAtTenantScopeSinglePageAsync(top, expand, context), nextLink -> this.listAtTenantScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ProviderInner> listAtTenantScope() {
        Integer top = null;
        String expand = null;
        return new PagedIterable(this.listAtTenantScopeAsync(top, expand));
    }

    @Override
    public PagedIterable<ProviderInner> listAtTenantScope(Integer top, String expand, Context context) {
        return new PagedIterable(this.listAtTenantScopeAsync(top, expand, context));
    }

    @Override
    public Mono<Response<ProviderInner>> getWithResponseAsync(String resourceProviderNamespace, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), expand, resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ProviderInner>> getWithResponseAsync(String resourceProviderNamespace, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), expand, resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public Mono<ProviderInner> getAsync(String resourceProviderNamespace, String expand) {
        return this.getWithResponseAsync(resourceProviderNamespace, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ProviderInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ProviderInner> getAsync(String resourceProviderNamespace) {
        String expand = null;
        return this.getWithResponseAsync(resourceProviderNamespace, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ProviderInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ProviderInner get(String resourceProviderNamespace) {
        String expand = null;
        return (ProviderInner)this.getAsync(resourceProviderNamespace, expand).block();
    }

    @Override
    public Response<ProviderInner> getWithResponse(String resourceProviderNamespace, String expand, Context context) {
        return (Response)this.getWithResponseAsync(resourceProviderNamespace, expand, context).block();
    }

    @Override
    public Mono<Response<ProviderInner>> getAtTenantScopeWithResponseAsync(String resourceProviderNamespace, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtTenantScope(this.client.getEndpoint(), expand, resourceProviderNamespace, this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ProviderInner>> getAtTenantScopeWithResponseAsync(String resourceProviderNamespace, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtTenantScope(this.client.getEndpoint(), expand, resourceProviderNamespace, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<ProviderInner> getAtTenantScopeAsync(String resourceProviderNamespace, String expand) {
        return this.getAtTenantScopeWithResponseAsync(resourceProviderNamespace, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ProviderInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ProviderInner> getAtTenantScopeAsync(String resourceProviderNamespace) {
        String expand = null;
        return this.getAtTenantScopeWithResponseAsync(resourceProviderNamespace, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ProviderInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ProviderInner getAtTenantScope(String resourceProviderNamespace) {
        String expand = null;
        return (ProviderInner)this.getAtTenantScopeAsync(resourceProviderNamespace, expand).block();
    }

    @Override
    public Response<ProviderInner> getAtTenantScopeWithResponse(String resourceProviderNamespace, String expand, Context context) {
        return (Response)this.getAtTenantScopeWithResponseAsync(resourceProviderNamespace, expand, context).block();
    }

    private Mono<PagedResponse<ProviderInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ProviderInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<ProviderInner>> listAtTenantScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtTenantScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ProviderInner>> listAtTenantScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAtTenantScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProviderListResult)res.getValue()).value(), ((ProviderListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ResourceManagementCl")
    private static interface ProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/unregister")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderInner>> unregister(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{groupId}/providers/{resourceProviderNamespace}/register")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> registerAtManagementGroupScope(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="groupId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/register")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderInner>> register(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$expand") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderListResult>> listAtTenantScope(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$expand") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="$expand") String var2, @PathParam(value="resourceProviderNamespace") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/{resourceProviderNamespace}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderInner>> getAtTenantScope(@HostParam(value="$host") String var1, @QueryParam(value="$expand") String var2, @PathParam(value="resourceProviderNamespace") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProviderListResult>> listAtTenantScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

