/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.azure.resourcemanager.resources.fluent.ResourcesClient;
import com.azure.resourcemanager.resources.fluent.models.GenericResourceInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.implementation.GenericResourceImpl;
import com.azure.resourcemanager.resources.models.GenericResource;
import com.azure.resourcemanager.resources.models.GenericResources;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.ResourcesMoveInfo;
import java.util.List;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class GenericResourcesImpl
extends GroupableResourcesImpl<GenericResource, GenericResourceImpl, GenericResourceInner, ResourcesClient, ResourceManager>
implements GenericResources {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    public GenericResourcesImpl(ResourceManager resourceManager) {
        super(((ResourceManagementClient)resourceManager.serviceClient()).getResources(), resourceManager);
    }

    @Override
    public PagedIterable<GenericResource> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<GenericResource> listByResourceGroup(String groupName) {
        return new PagedIterable(this.listByResourceGroupAsync(groupName));
    }

    @Override
    public PagedIterable<GenericResource> listByTag(String resourceGroupName, String tagName, String tagValue) {
        return new PagedIterable(this.listByTagAsync(resourceGroupName, tagName, tagValue));
    }

    @Override
    public PagedFlux<GenericResource> listByTagAsync(String resourceGroupName, String tagName, String tagValue) {
        return this.wrapPageAsync(PagedConverter.mapPage(((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources().listByResourceGroupAsync(resourceGroupName, ResourceManagerUtils.createOdataFilterForTags(tagName, tagValue), null, null), res -> res));
    }

    @Override
    public GenericResource.DefinitionStages.Blank define(String name) {
        return new GenericResourceImpl(name, new GenericResourceInner(), (ResourceManager)this.manager());
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesClient)this.inner()).checkExistence(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    public boolean checkExistenceById(String id) {
        String apiVersion = (String)this.getApiVersionFromId(id).block();
        return ((ResourcesClient)this.inner()).checkExistenceById(id, apiVersion);
    }

    @Override
    public GenericResource getById(String id) {
        Provider provider = (Provider)((ResourceManager)this.manager()).providers().getByName(ResourceUtils.resourceProviderFromResourceId(id));
        String apiVersion = ResourceUtils.defaultApiVersion(id, provider);
        GenericResourceImpl genericResource = this.wrapModel(((ResourcesClient)this.inner()).getById(id, apiVersion));
        return genericResource.withApiVersion(apiVersion);
    }

    @Override
    public GenericResource get(String resourceGroupName, String providerNamespace, String resourceType, String name) {
        PagedIterable<GenericResource> genericResources = this.listByResourceGroup(resourceGroupName);
        for (GenericResource resource : genericResources) {
            if (!resource.name().equalsIgnoreCase(name) || !resource.resourceProviderNamespace().equalsIgnoreCase(providerNamespace) || !resource.resourceType().equalsIgnoreCase(resourceType)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public GenericResource get(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (parentResourcePath == null) {
            parentResourcePath = "";
        }
        GenericResourceInner inner = ((ResourcesClient)this.inner()).get(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
        GenericResourceImpl resource = new GenericResourceImpl(resourceName, inner, (ResourceManager)this.manager());
        return ((GenericResourceImpl)resource.withExistingResourceGroup(resourceGroupName)).withProviderNamespace(resourceProviderNamespace).withParentResourcePath(parentResourcePath).withResourceType(resourceType).withApiVersion(apiVersion);
    }

    @Override
    public void moveResources(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resources) {
        this.moveResourcesAsync(sourceResourceGroupName, targetResourceGroup, resources).block();
    }

    @Override
    public Mono<Void> moveResourcesAsync(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resources) {
        ResourcesMoveInfo moveInfo = new ResourcesMoveInfo();
        moveInfo.withTargetResourceGroup(targetResourceGroup.id());
        moveInfo.withResources(resources);
        return ((ResourcesClient)this.inner()).moveResourcesAsync(sourceResourceGroupName, moveInfo);
    }

    @Override
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).block();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesClient)this.inner()).deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    protected GenericResourceImpl wrapModel(String id) {
        return ((GenericResourceImpl)new GenericResourceImpl(id, new GenericResourceInner(), (ResourceManager)this.manager()).withExistingResourceGroup(ResourceUtils.groupFromResourceId(id))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(id)).withResourceType(ResourceUtils.resourceTypeFromResourceId(id)).withParentResourceId(ResourceUtils.parentResourceIdFromResourceId(id));
    }

    @Override
    protected GenericResourceImpl wrapModel(GenericResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return ((GenericResourceImpl)new GenericResourceImpl(inner.id(), inner, (ResourceManager)this.manager()).withExistingResourceGroup(ResourceUtils.groupFromResourceId(inner.id()))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(inner.id())).withResourceType(ResourceUtils.resourceTypeFromResourceId(inner.id())).withParentResourceId(ResourceUtils.parentResourceIdFromResourceId(inner.id()));
    }

    @Override
    public Mono<GenericResourceInner> getInnerAsync(String groupName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Get just by resource group and name is not supported. Please use other overloads."));
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Delete just by resource group and name is not supported. Please use other overloads."));
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        ResourcesClient inner = (ResourcesClient)this.inner();
        return this.getApiVersionFromId(id).flatMap(apiVersion -> inner.deleteByIdAsync(id, (String)apiVersion));
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        String apiVersion = (String)this.getApiVersionFromId(id).block();
        return AcceptedImpl.newAccepted(this.logger, ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getHttpPipeline(), ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ResourcesClient)this.inner()).deleteByIdWithResponseAsync(id, apiVersion).block(), Function.identity(), Void.class, null);
    }

    private Mono<String> getApiVersionFromId(String id) {
        return ((ResourceManager)this.manager()).providers().getByNameAsync(ResourceUtils.resourceProviderFromResourceId(id)).map(provider -> ResourceUtils.defaultApiVersion(id, provider));
    }

    @Override
    public PagedFlux<GenericResource> listAsync() {
        return this.wrapPageAsync(PagedConverter.mapPage(((ResourcesClient)this.inner()).listAsync(), res -> res));
    }

    @Override
    public PagedFlux<GenericResource> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(PagedConverter.mapPage(((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources().listByResourceGroupAsync(resourceGroupName), res -> res));
    }
}

