/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.fluent.FeatureClient;
import com.azure.resourcemanager.resources.fluent.ManagementLockClient;
import com.azure.resourcemanager.resources.fluent.PolicyClient;
import com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.azure.resourcemanager.resources.fluent.SubscriptionClient;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.implementation.DeploymentsImpl;
import com.azure.resourcemanager.resources.implementation.FeatureClientBuilder;
import com.azure.resourcemanager.resources.implementation.FeaturesImpl;
import com.azure.resourcemanager.resources.implementation.GenericResourcesImpl;
import com.azure.resourcemanager.resources.implementation.ManagementLockClientBuilder;
import com.azure.resourcemanager.resources.implementation.ManagementLocksImpl;
import com.azure.resourcemanager.resources.implementation.PolicyAssignmentsImpl;
import com.azure.resourcemanager.resources.implementation.PolicyClientBuilder;
import com.azure.resourcemanager.resources.implementation.PolicyDefinitionsImpl;
import com.azure.resourcemanager.resources.implementation.ProvidersImpl;
import com.azure.resourcemanager.resources.implementation.ResourceGroupsImpl;
import com.azure.resourcemanager.resources.implementation.ResourceManagementClientBuilder;
import com.azure.resourcemanager.resources.implementation.SubscriptionClientBuilder;
import com.azure.resourcemanager.resources.implementation.SubscriptionsImpl;
import com.azure.resourcemanager.resources.implementation.TenantsImpl;
import com.azure.resourcemanager.resources.models.Deployments;
import com.azure.resourcemanager.resources.models.Features;
import com.azure.resourcemanager.resources.models.GenericResources;
import com.azure.resourcemanager.resources.models.ManagementLocks;
import com.azure.resourcemanager.resources.models.PolicyAssignments;
import com.azure.resourcemanager.resources.models.PolicyDefinitions;
import com.azure.resourcemanager.resources.models.Providers;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import com.azure.resourcemanager.resources.models.Subscriptions;
import com.azure.resourcemanager.resources.models.Tenants;
import java.util.Objects;

public final class ResourceManager
extends Manager<ResourceManagementClient> {
    private final FeatureClient featureClient;
    private final SubscriptionClient subscriptionClient;
    private final PolicyClient policyClient;
    private final ManagementLockClient managementLockClient;
    private ResourceGroups resourceGroups;
    private GenericResources genericResources;
    private Deployments deployments;
    private Features features;
    private Providers providers;
    private PolicyDefinitions policyDefinitions;
    private PolicyAssignments policyAssignments;
    private Subscriptions subscriptions;
    private Tenants tenants;
    private ManagementLocks managementLocks;
    private ResourceManagerUtils.InternalRuntimeContext internalContext;

    public static Authenticated authenticate(TokenCredential credential, AzureProfile profile) {
        return new AuthenticatedImpl(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    private static Authenticated authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new AuthenticatedImpl(httpPipeline, profile);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    private ResourceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(null, profile, new ResourceManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        super.withResourceManager(this);
        this.featureClient = new FeatureClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient();
        this.subscriptionClient = new SubscriptionClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).buildClient();
        this.policyClient = new PolicyClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient();
        this.managementLockClient = new ManagementLockClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient();
        for (int i = 0; i < httpPipeline.getPolicyCount(); ++i) {
            ProviderRegistrationPolicy policy;
            if (!(httpPipeline.getPolicy(i) instanceof ProviderRegistrationPolicy) || (policy = (ProviderRegistrationPolicy)httpPipeline.getPolicy(i)).getProviders() != null) continue;
            policy.setProviders(this.providers());
        }
    }

    public FeatureClient featureClient() {
        return this.featureClient;
    }

    public SubscriptionClient subscriptionClient() {
        return this.subscriptionClient;
    }

    public PolicyClient policyClient() {
        return this.policyClient;
    }

    public ManagementLockClient managementLockClient() {
        return this.managementLockClient;
    }

    public ResourceGroups resourceGroups() {
        if (this.resourceGroups == null) {
            this.resourceGroups = new ResourceGroupsImpl(this);
        }
        return this.resourceGroups;
    }

    public GenericResources genericResources() {
        if (this.genericResources == null) {
            this.genericResources = new GenericResourcesImpl(this);
        }
        return this.genericResources;
    }

    public Deployments deployments() {
        if (this.deployments == null) {
            this.deployments = new DeploymentsImpl(this);
        }
        return this.deployments;
    }

    public Features features() {
        if (this.features == null) {
            this.features = new FeaturesImpl(this.featureClient.getFeatures());
        }
        return this.features;
    }

    public Providers providers() {
        if (this.providers == null) {
            this.providers = new ProvidersImpl(((ResourceManagementClient)this.serviceClient()).getProviders());
        }
        return this.providers;
    }

    public PolicyDefinitions policyDefinitions() {
        if (this.policyDefinitions == null) {
            this.policyDefinitions = new PolicyDefinitionsImpl(this.policyClient.getPolicyDefinitions());
        }
        return this.policyDefinitions;
    }

    public PolicyAssignments policyAssignments() {
        if (this.policyAssignments == null) {
            this.policyAssignments = new PolicyAssignmentsImpl(this.policyClient.getPolicyAssignments());
        }
        return this.policyAssignments;
    }

    public Subscriptions subscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new SubscriptionsImpl(this.subscriptionClient.getSubscriptions());
        }
        return this.subscriptions;
    }

    public Tenants tenants() {
        if (this.tenants == null) {
            this.tenants = new TenantsImpl(this.subscriptionClient.getTenants());
        }
        return this.tenants;
    }

    public ManagementLocks managementLocks() {
        if (this.managementLocks == null) {
            this.managementLocks = new ManagementLocksImpl(this);
        }
        return this.managementLocks;
    }

    public ResourceManagerUtils.InternalRuntimeContext internalContext() {
        if (this.internalContext == null) {
            this.internalContext = new ResourceManagerUtils.InternalRuntimeContext();
        }
        return this.internalContext;
    }

    private static final class AuthenticatedImpl
    implements Authenticated {
        private final HttpPipeline httpPipeline;
        private AzureProfile profile;
        private final SubscriptionClient subscriptionClient;
        private Subscriptions subscriptions;
        private Tenants tenants;

        AuthenticatedImpl(HttpPipeline httpPipeline, AzureProfile profile) {
            this.httpPipeline = httpPipeline;
            this.profile = profile;
            this.subscriptionClient = new SubscriptionClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).buildClient();
        }

        @Override
        public Subscriptions subscriptions() {
            if (this.subscriptions == null) {
                this.subscriptions = new SubscriptionsImpl(this.subscriptionClient.getSubscriptions());
            }
            return this.subscriptions;
        }

        @Override
        public Tenants tenants() {
            if (this.tenants == null) {
                this.tenants = new TenantsImpl(this.subscriptionClient.getTenants());
            }
            return this.tenants;
        }

        @Override
        public ResourceManager withSubscription(String subscriptionId) {
            Objects.requireNonNull(subscriptionId);
            this.profile = new AzureProfile(this.profile.getTenantId(), subscriptionId, this.profile.getEnvironment());
            return new ResourceManager(this.httpPipeline, this.profile);
        }

        @Override
        public ResourceManager withDefaultSubscription() {
            if (this.profile.getSubscriptionId() == null) {
                String subscriptionId = ResourceManagerUtils.getDefaultSubscription(this.subscriptions().list());
                this.profile = new AzureProfile(this.profile.getTenantId(), subscriptionId, this.profile.getEnvironment());
            }
            return new ResourceManager(this.httpPipeline, this.profile);
        }
    }

    public static interface Authenticated {
        public Tenants tenants();

        public Subscriptions subscriptions();

        public ResourceManager withSubscription(String var1);

        public ResourceManager withDefaultSubscription();
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public Authenticated authenticate(TokenCredential credential, AzureProfile profile) {
            return ResourceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public Authenticated authenticate(TokenCredential var1, AzureProfile var2);
    }
}

