// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of resource types of a resource provider. */
@Fluent
public final class ProviderResourceTypeListResultInner {
    /*
     * An array of resource types.
     */
    @JsonProperty(value = "value")
    private List<ProviderResourceType> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: An array of resource types.
     *
     * @return the value value.
     */
    public List<ProviderResourceType> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of resource types.
     *
     * @param value the value value to set.
     * @return the ProviderResourceTypeListResultInner object itself.
     */
    public ProviderResourceTypeListResultInner withValue(List<ProviderResourceType> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
