/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class PolicyDefinitionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PolicyDefinitionProperties.class);
    @JsonProperty(value="policyType")
    private PolicyType policyType;
    @JsonProperty(value="mode")
    private String mode;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="policyRule")
    private Object policyRule;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, ParameterDefinitionsValue> parameters;

    public PolicyType policyType() {
        return this.policyType;
    }

    public PolicyDefinitionProperties withPolicyType(PolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    public String mode() {
        return this.mode;
    }

    public PolicyDefinitionProperties withMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicyDefinitionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object policyRule() {
        return this.policyRule;
    }

    public PolicyDefinitionProperties withPolicyRule(Object policyRule) {
        this.policyRule = policyRule;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicyDefinitionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.parameters;
    }

    public PolicyDefinitionProperties withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

