/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.AuthorizationProfile;
import com.azure.resourcemanager.resources.models.SubscriptionFeatureRegistrationApprovalType;
import com.azure.resourcemanager.resources.models.SubscriptionFeatureRegistrationState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SubscriptionFeatureRegistrationProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SubscriptionFeatureRegistrationProperties.class);
    @JsonProperty(value="tenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantId;
    @JsonProperty(value="subscriptionId", access=JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;
    @JsonProperty(value="featureName", access=JsonProperty.Access.WRITE_ONLY)
    private String featureName;
    @JsonProperty(value="displayName", access=JsonProperty.Access.WRITE_ONLY)
    private String displayName;
    @JsonProperty(value="providerNamespace", access=JsonProperty.Access.WRITE_ONLY)
    private String providerNamespace;
    @JsonProperty(value="state")
    private SubscriptionFeatureRegistrationState state;
    @JsonProperty(value="authorizationProfile")
    private AuthorizationProfile authorizationProfile;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> metadata;
    @JsonProperty(value="releaseDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime releaseDate;
    @JsonProperty(value="registrationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime registrationDate;
    @JsonProperty(value="documentationLink", access=JsonProperty.Access.WRITE_ONLY)
    private String documentationLink;
    @JsonProperty(value="approvalType", access=JsonProperty.Access.WRITE_ONLY)
    private SubscriptionFeatureRegistrationApprovalType approvalType;
    @JsonProperty(value="shouldFeatureDisplayInPortal")
    private Boolean shouldFeatureDisplayInPortal;
    @JsonProperty(value="description")
    private String description;

    public String tenantId() {
        return this.tenantId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String featureName() {
        return this.featureName;
    }

    public String displayName() {
        return this.displayName;
    }

    public String providerNamespace() {
        return this.providerNamespace;
    }

    public SubscriptionFeatureRegistrationState state() {
        return this.state;
    }

    public SubscriptionFeatureRegistrationProperties withState(SubscriptionFeatureRegistrationState state) {
        this.state = state;
        return this;
    }

    public AuthorizationProfile authorizationProfile() {
        return this.authorizationProfile;
    }

    public SubscriptionFeatureRegistrationProperties withAuthorizationProfile(AuthorizationProfile authorizationProfile) {
        this.authorizationProfile = authorizationProfile;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public SubscriptionFeatureRegistrationProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public OffsetDateTime releaseDate() {
        return this.releaseDate;
    }

    public OffsetDateTime registrationDate() {
        return this.registrationDate;
    }

    public String documentationLink() {
        return this.documentationLink;
    }

    public SubscriptionFeatureRegistrationApprovalType approvalType() {
        return this.approvalType;
    }

    public Boolean shouldFeatureDisplayInPortal() {
        return this.shouldFeatureDisplayInPortal;
    }

    public SubscriptionFeatureRegistrationProperties withShouldFeatureDisplayInPortal(Boolean shouldFeatureDisplayInPortal) {
        this.shouldFeatureDisplayInPortal = shouldFeatureDisplayInPortal;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SubscriptionFeatureRegistrationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.authorizationProfile() != null) {
            this.authorizationProfile().validate();
        }
    }
}

