/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluent.SubscriptionsClient;
import com.azure.resourcemanager.resources.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.azure.resourcemanager.resources.implementation.LocationImpl;
import com.azure.resourcemanager.resources.models.Location;
import com.azure.resourcemanager.resources.models.Subscription;
import com.azure.resourcemanager.resources.models.SubscriptionPolicies;
import com.azure.resourcemanager.resources.models.SubscriptionState;

final class SubscriptionImpl
extends IndexableWrapperImpl<SubscriptionInner>
implements Subscription {
    private final SubscriptionsClient client;

    SubscriptionImpl(SubscriptionInner innerModel, SubscriptionsClient client) {
        super(innerModel);
        this.client = client;
    }

    @Override
    public String subscriptionId() {
        return ((SubscriptionInner)this.innerModel()).subscriptionId();
    }

    @Override
    public String displayName() {
        return ((SubscriptionInner)this.innerModel()).displayName();
    }

    @Override
    public SubscriptionState state() {
        return ((SubscriptionInner)this.innerModel()).state();
    }

    @Override
    public SubscriptionPolicies subscriptionPolicies() {
        return ((SubscriptionInner)this.innerModel()).subscriptionPolicies();
    }

    @Override
    public PagedIterable<Location> listLocations() {
        return this.client.listLocations(this.subscriptionId()).mapPage(LocationImpl::new);
    }

    @Override
    public Location getLocationByRegion(Region region) {
        if (region != null) {
            PagedIterable<Location> locations = this.listLocations();
            for (Location location : locations) {
                if (!region.equals((Object)location.region())) continue;
                return location;
            }
        }
        return null;
    }
}

