/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.PolicyDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionInner;
import com.azure.resourcemanager.resources.implementation.PolicyClientImpl;
import com.azure.resourcemanager.resources.models.PolicyDefinitionListResult;
import reactor.core.publisher.Mono;

public final class PolicyDefinitionsClientImpl
implements PolicyDefinitionsClient {
    private final ClientLogger logger = new ClientLogger(PolicyDefinitionsClientImpl.class);
    private final PolicyDefinitionsService service;
    private final PolicyClientImpl client;

    PolicyDefinitionsClientImpl(PolicyClientImpl client) {
        this.service = (PolicyDefinitionsService)RestProxy.create(PolicyDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<PolicyDefinitionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName, PolicyDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicyDefinitionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName, PolicyDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<PolicyDefinitionInner> createOrUpdateAsync(String policyDefinitionName, PolicyDefinitionInner parameters) {
        return this.createOrUpdateWithResponseAsync(policyDefinitionName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicyDefinitionInner createOrUpdate(String policyDefinitionName, PolicyDefinitionInner parameters) {
        return (PolicyDefinitionInner)((Object)this.createOrUpdateAsync(policyDefinitionName, parameters).block());
    }

    @Override
    public Response<PolicyDefinitionInner> createOrUpdateWithResponse(String policyDefinitionName, PolicyDefinitionInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(policyDefinitionName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String policyDefinitionName) {
        return this.deleteWithResponseAsync(policyDefinitionName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String policyDefinitionName) {
        this.deleteAsync(policyDefinitionName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String policyDefinitionName, Context context) {
        return (Response)this.deleteWithResponseAsync(policyDefinitionName, context).block();
    }

    @Override
    public Mono<Response<PolicyDefinitionInner>> getWithResponseAsync(String policyDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicyDefinitionInner>> getWithResponseAsync(String policyDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<PolicyDefinitionInner> getAsync(String policyDefinitionName) {
        return this.getWithResponseAsync(policyDefinitionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicyDefinitionInner get(String policyDefinitionName) {
        return (PolicyDefinitionInner)((Object)this.getAsync(policyDefinitionName).block());
    }

    @Override
    public Response<PolicyDefinitionInner> getWithResponse(String policyDefinitionName, Context context) {
        return (Response)this.getWithResponseAsync(policyDefinitionName, context).block();
    }

    @Override
    public Mono<Response<PolicyDefinitionInner>> getBuiltInWithResponseAsync(String policyDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getBuiltIn(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicyDefinitionInner>> getBuiltInWithResponseAsync(String policyDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getBuiltIn(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), context);
    }

    @Override
    public Mono<PolicyDefinitionInner> getBuiltInAsync(String policyDefinitionName) {
        return this.getBuiltInWithResponseAsync(policyDefinitionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicyDefinitionInner getBuiltIn(String policyDefinitionName) {
        return (PolicyDefinitionInner)((Object)this.getBuiltInAsync(policyDefinitionName).block());
    }

    @Override
    public Response<PolicyDefinitionInner> getBuiltInWithResponse(String policyDefinitionName, Context context) {
        return (Response)this.getBuiltInWithResponseAsync(policyDefinitionName, context).block();
    }

    @Override
    public Mono<Response<PolicyDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), managementGroupId, parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicyDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), managementGroupId, parameters, context);
    }

    @Override
    public Mono<PolicyDefinitionInner> createOrUpdateAtManagementGroupAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicyDefinitionInner createOrUpdateAtManagementGroup(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        return (PolicyDefinitionInner)((Object)this.createOrUpdateAtManagementGroupAsync(policyDefinitionName, managementGroupId, parameters).block());
    }

    @Override
    public Response<PolicyDefinitionInner> createOrUpdateAtManagementGroupWithResponse(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters, Context context) {
        return (Response)this.createOrUpdateAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), managementGroupId, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), managementGroupId, context);
    }

    @Override
    public Mono<Void> deleteAtManagementGroupAsync(String policyDefinitionName, String managementGroupId) {
        return this.deleteAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteAtManagementGroup(String policyDefinitionName, String managementGroupId) {
        this.deleteAtManagementGroupAsync(policyDefinitionName, managementGroupId).block();
    }

    @Override
    public Response<Void> deleteAtManagementGroupWithResponse(String policyDefinitionName, String managementGroupId, Context context) {
        return (Response)this.deleteAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, context).block();
    }

    @Override
    public Mono<Response<PolicyDefinitionInner>> getAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), managementGroupId, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicyDefinitionInner>> getAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, this.client.getApiVersion(), managementGroupId, context);
    }

    @Override
    public Mono<PolicyDefinitionInner> getAtManagementGroupAsync(String policyDefinitionName, String managementGroupId) {
        return this.getAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicyDefinitionInner getAtManagementGroup(String policyDefinitionName, String managementGroupId) {
        return (PolicyDefinitionInner)((Object)this.getAtManagementGroupAsync(policyDefinitionName, managementGroupId).block());
    }

    @Override
    public Response<PolicyDefinitionInner> getAtManagementGroupWithResponse(String policyDefinitionName, String managementGroupId, Context context) {
        return (Response)this.getAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, context).block();
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PolicyDefinitionInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PolicyDefinitionInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PolicyDefinitionInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<PolicyDefinitionInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBuiltIn(this.client.getEndpoint(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBuiltIn(this.client.getEndpoint(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PolicyDefinitionInner> listBuiltInAsync() {
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PolicyDefinitionInner> listBuiltInAsync(Context context) {
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(context), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PolicyDefinitionInner> listBuiltIn() {
        return new PagedIterable(this.listBuiltInAsync());
    }

    @Override
    public PagedIterable<PolicyDefinitionInner> listBuiltIn(Context context) {
        return new PagedIterable(this.listBuiltInAsync(context));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByManagementGroup(this.client.getEndpoint(), this.client.getApiVersion(), managementGroupId, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroup(this.client.getEndpoint(), this.client.getApiVersion(), managementGroupId, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PolicyDefinitionInner> listByManagementGroupAsync(String managementGroupId) {
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PolicyDefinitionInner> listByManagementGroupAsync(String managementGroupId, Context context) {
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, context), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PolicyDefinitionInner> listByManagementGroup(String managementGroupId) {
        return new PagedIterable(this.listByManagementGroupAsync(managementGroupId));
    }

    @Override
    public PagedIterable<PolicyDefinitionInner> listByManagementGroup(String managementGroupId, Context context) {
        return new PagedIterable(this.listByManagementGroupAsync(managementGroupId, context));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBuiltInNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBuiltInNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByManagementGroupNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroupNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyClientPolicyDe")
    private static interface PolicyDefinitionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") PolicyDefinitionInner var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> getBuiltIn(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, @BodyParam(value="application/json") PolicyDefinitionInner var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policyDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listBuiltIn(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listByManagementGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="managementGroupId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listBuiltInNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listByManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

