/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.utils;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.paging.PageRetriever;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PagedConverter {
    private PagedConverter() {
    }

    public static <T, S> PagedFlux<S> flatMapPage(PagedFlux<T> pagedFlux, Function<? super T, ? extends Publisher<? extends S>> mapper) {
        Supplier<PageRetriever> provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage(continuationToken);
            return flux.concatMap(PagedConverter.flatMapPagedResponse(mapper));
        };
        return PagedFlux.create(provider);
    }

    public static <T, S> PagedFlux<S> mergePagedFlux(PagedFlux<T> pagedFlux, Function<? super T, PagedFlux<S>> transformer) {
        Supplier<PageRetriever> provider = () -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage(continuationToken);
            return flux.concatMap(PagedConverter.mergePagedFluxPagedResponse(transformer));
        };
        return PagedFlux.create(provider);
    }

    private static <T, S> Function<PagedResponse<T>, Mono<PagedResponse<S>>> flatMapPagedResponse(Function<? super T, ? extends Publisher<? extends S>> mapper) {
        return pagedResponse -> Flux.fromIterable((Iterable)pagedResponse.getValue()).flatMapSequential(mapper).collectList().map(values -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), values, (String)pagedResponse.getContinuationToken(), null));
    }

    private static <T, S> Function<PagedResponse<T>, Flux<PagedResponse<S>>> mergePagedFluxPagedResponse(Function<? super T, PagedFlux<S>> transformer) {
        return pagedResponse -> {
            List fluxList = pagedResponse.getValue().stream().map(item -> ((PagedFlux)transformer.apply(item)).byPage()).collect(Collectors.toList());
            return Flux.concat(fluxList).filter(p -> !p.getValue().isEmpty());
        };
    }

    public static <T> PagedFlux<T> convertListToPagedFlux(Mono<Response<List<T>>> responseMono) {
        return new PagedFlux(() -> responseMono.map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (List)response.getValue(), null, null)));
    }
}

