/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.deploymentstacks.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackInner;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackProperties;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackTemplateDefinition;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackValidateResult;
import java.util.Map;

public interface DeploymentStack {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String location();

    public Map<String, String> tags();

    public DeploymentStackProperties properties();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public DeploymentStackInner innerModel();

    public Update update();

    public DeploymentStack refresh();

    public DeploymentStack refresh(Context var1);

    public Response<DeploymentStackTemplateDefinition> exportTemplateAtResourceGroupWithResponse(Context var1);

    public DeploymentStackTemplateDefinition exportTemplateAtResourceGroup();

    public DeploymentStackValidateResult validateStackAtResourceGroup(DeploymentStackInner var1);

    public DeploymentStackValidateResult validateStackAtResourceGroup(DeploymentStackInner var1, Context var2);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(DeploymentStackProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public DeploymentStack apply();

        public DeploymentStack apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithProperties {
            public WithCreate withProperties(DeploymentStackProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithProperties {
            public DeploymentStack create();

            public DeploymentStack create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface Blank
        extends WithResourceGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

