/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.deploymentstacks.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.deploymentstacks.models.AzureResourceBase;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackProperties;
import java.io.IOException;
import java.util.Map;

public final class DeploymentStackInner
extends AzureResourceBase {
    private String location;
    private Map<String, String> tags;
    private DeploymentStackProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public String location() {
        return this.location;
    }

    public DeploymentStackInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DeploymentStackInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DeploymentStackProperties properties() {
        return this.properties;
    }

    public DeploymentStackInner withProperties(DeploymentStackProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentStackInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentStackInner)((Object)jsonReader.readObject(reader -> {
            DeploymentStackInner deserializedDeploymentStackInner = new DeploymentStackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeploymentStackInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeploymentStackInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeploymentStackInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDeploymentStackInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDeploymentStackInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeploymentStackInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentStackInner.properties = DeploymentStackProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentStackInner;
        }));
    }
}

