/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.azure.resourcemanager.redis.fluent.models.RedisPropertiesInner;
import com.azure.resourcemanager.redis.models.ManagedServiceIdentity;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.RedisInstanceDetails;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.azure.resourcemanager.redis.models.UpdateChannel;
import com.azure.resourcemanager.redis.models.ZonalAllocationPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RedisResourceInner
extends Resource {
    private RedisPropertiesInner innerProperties = new RedisPropertiesInner();
    private List<String> zones;
    private ManagedServiceIdentity identity;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(RedisResourceInner.class);

    private RedisPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public RedisResourceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public RedisResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RedisResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RedisResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    public Integer sslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().sslPort();
    }

    public RedisAccessKeysInner accessKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().accessKeys();
    }

    public List<RedisLinkedServer> linkedServers() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedServers();
    }

    public List<RedisInstanceDetails> instances() {
        return this.innerProperties() == null ? null : this.innerProperties().instances();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public RedisResourceInner withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public RedisResourceInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public RedisResourceInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public RedisConfiguration redisConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().redisConfiguration();
    }

    public RedisResourceInner withRedisConfiguration(RedisConfiguration redisConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withRedisConfiguration(redisConfiguration);
        return this;
    }

    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    public RedisResourceInner withRedisVersion(String redisVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withRedisVersion(redisVersion);
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNonSslPort();
    }

    public RedisResourceInner withEnableNonSslPort(Boolean enableNonSslPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    public Integer replicasPerMaster() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerMaster();
    }

    public RedisResourceInner withReplicasPerMaster(Integer replicasPerMaster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    public Integer replicasPerPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerPrimary();
    }

    public RedisResourceInner withReplicasPerPrimary(Integer replicasPerPrimary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantSettings();
    }

    public RedisResourceInner withTenantSettings(Map<String, String> tenantSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withTenantSettings((Map)tenantSettings);
        return this;
    }

    public Integer shardCount() {
        return this.innerProperties() == null ? null : this.innerProperties().shardCount();
    }

    public RedisResourceInner withShardCount(Integer shardCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withShardCount(shardCount);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public RedisResourceInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RedisResourceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public UpdateChannel updateChannel() {
        return this.innerProperties() == null ? null : this.innerProperties().updateChannel();
    }

    public RedisResourceInner withUpdateChannel(UpdateChannel updateChannel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withUpdateChannel(updateChannel);
        return this;
    }

    public Boolean disableAccessKeyAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().disableAccessKeyAuthentication();
    }

    public RedisResourceInner withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    public ZonalAllocationPolicy zonalAllocationPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().zonalAllocationPolicy();
    }

    public RedisResourceInner withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withZonalAllocationPolicy(zonalAllocationPolicy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RedisResourceInner"));
        }
        this.innerProperties().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static RedisResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (RedisResourceInner)((Object)jsonReader.readObject(reader -> {
            RedisResourceInner deserializedRedisResourceInner = new RedisResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRedisResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRedisResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRedisResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRedisResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRedisResourceInner.innerProperties = RedisPropertiesInner.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedRedisResourceInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRedisResourceInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisResourceInner;
        }));
    }
}

