/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class OperationStatusResult
implements JsonSerializable<OperationStatusResult> {
    private String id;
    private String name;
    private String status;
    private Float percentComplete;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<OperationStatusResult> operations;
    private ManagementError error;
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusResult.class);

    public String id() {
        return this.id;
    }

    public OperationStatusResult withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public OperationStatusResult withName(String name) {
        this.name = name;
        return this;
    }

    public String status() {
        return this.status;
    }

    public OperationStatusResult withStatus(String status) {
        this.status = status;
        return this;
    }

    public Float percentComplete() {
        return this.percentComplete;
    }

    public OperationStatusResult withPercentComplete(Float percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OperationStatusResult withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OperationStatusResult withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<OperationStatusResult> operations() {
        return this.operations;
    }

    public OperationStatusResult withOperations(List<OperationStatusResult> operations) {
        this.operations = operations;
        return this;
    }

    public ManagementError error() {
        return this.error;
    }

    public OperationStatusResult withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model OperationStatusResult"));
        }
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("percentComplete", (Number)this.percentComplete);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationStatusResult fromJson(JsonReader jsonReader) throws IOException {
        return (OperationStatusResult)jsonReader.readObject(reader -> {
            OperationStatusResult deserializedOperationStatusResult = new OperationStatusResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedOperationStatusResult.status = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedOperationStatusResult.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationStatusResult.name = reader.getString();
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedOperationStatusResult.percentComplete = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusResult.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusResult.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedOperationStatusResult.operations = operations = reader.readArray(reader1 -> OperationStatusResult.fromJson(reader1));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationStatusResult.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationStatusResult;
        });
    }
}

