/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.redis.fluent.PatchSchedulesClient;
import com.azure.resourcemanager.redis.fluent.models.RedisPatchScheduleInner;
import com.azure.resourcemanager.redis.implementation.RedisManagementClientImpl;
import com.azure.resourcemanager.redis.models.DefaultName;
import com.azure.resourcemanager.redis.models.RedisPatchScheduleListResult;
import com.azure.resourcemanager.redis.models.ScheduleEntry;
import java.util.List;
import reactor.core.publisher.Mono;

public final class PatchSchedulesClientImpl
implements PatchSchedulesClient {
    private final ClientLogger logger = new ClientLogger(PatchSchedulesClientImpl.class);
    private final PatchSchedulesService service;
    private final RedisManagementClientImpl client;

    PatchSchedulesClientImpl(RedisManagementClientImpl client) {
        this.service = (PatchSchedulesService)RestProxy.create(PatchSchedulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<RedisPatchScheduleInner>> listByRedisResourceSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByRedisResource(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cacheName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisPatchScheduleListResult)res.getValue()).value(), ((RedisPatchScheduleListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RedisPatchScheduleInner>> listByRedisResourceSinglePageAsync(String resourceGroupName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByRedisResource(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cacheName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisPatchScheduleListResult)res.getValue()).value(), ((RedisPatchScheduleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RedisPatchScheduleInner> listByRedisResourceAsync(String resourceGroupName, String cacheName) {
        return new PagedFlux(() -> this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName), nextLink -> this.listByRedisResourceNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RedisPatchScheduleInner> listByRedisResourceAsync(String resourceGroupName, String cacheName, Context context) {
        return new PagedFlux(() -> this.listByRedisResourceSinglePageAsync(resourceGroupName, cacheName, context), nextLink -> this.listByRedisResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RedisPatchScheduleInner> listByRedisResource(String resourceGroupName, String cacheName) {
        return new PagedIterable(this.listByRedisResourceAsync(resourceGroupName, cacheName));
    }

    @Override
    public PagedIterable<RedisPatchScheduleInner> listByRedisResource(String resourceGroupName, String cacheName, Context context) {
        return new PagedIterable(this.listByRedisResourceAsync(resourceGroupName, cacheName, context));
    }

    @Override
    public Mono<Response<RedisPatchScheduleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String name, DefaultName defaultParameter, List<ScheduleEntry> scheduleEntries) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (scheduleEntries == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scheduleEntries is required and cannot be null."));
        }
        scheduleEntries.forEach(e -> e.validate());
        RedisPatchScheduleInner parameters = new RedisPatchScheduleInner();
        parameters.withScheduleEntries(scheduleEntries);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name, defaultParameter, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RedisPatchScheduleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String name, DefaultName defaultParameter, List<ScheduleEntry> scheduleEntries, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (scheduleEntries == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scheduleEntries is required and cannot be null."));
        }
        scheduleEntries.forEach(e -> e.validate());
        RedisPatchScheduleInner parameters = new RedisPatchScheduleInner();
        parameters.withScheduleEntries(scheduleEntries);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name, defaultParameter, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<RedisPatchScheduleInner> createOrUpdateAsync(String resourceGroupName, String name, DefaultName defaultParameter, List<ScheduleEntry> scheduleEntries) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, name, defaultParameter, scheduleEntries).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RedisPatchScheduleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RedisPatchScheduleInner createOrUpdate(String resourceGroupName, String name, DefaultName defaultParameter, List<ScheduleEntry> scheduleEntries) {
        return (RedisPatchScheduleInner)((Object)this.createOrUpdateAsync(resourceGroupName, name, defaultParameter, scheduleEntries).block());
    }

    @Override
    public Response<RedisPatchScheduleInner> createOrUpdateWithResponse(String resourceGroupName, String name, DefaultName defaultParameter, List<ScheduleEntry> scheduleEntries, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, name, defaultParameter, scheduleEntries, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, DefaultName defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, name, defaultParameter, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, DefaultName defaultParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, name, defaultParameter, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String name, DefaultName defaultParameter) {
        return this.deleteWithResponseAsync(resourceGroupName, name, defaultParameter).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String name, DefaultName defaultParameter) {
        this.deleteAsync(resourceGroupName, name, defaultParameter).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String name, DefaultName defaultParameter, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, name, defaultParameter, context).block();
    }

    @Override
    public Mono<Response<RedisPatchScheduleInner>> getWithResponseAsync(String resourceGroupName, String name, DefaultName defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, name, defaultParameter, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<RedisPatchScheduleInner>> getWithResponseAsync(String resourceGroupName, String name, DefaultName defaultParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, name, defaultParameter, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<RedisPatchScheduleInner> getAsync(String resourceGroupName, String name, DefaultName defaultParameter) {
        return this.getWithResponseAsync(resourceGroupName, name, defaultParameter).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RedisPatchScheduleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RedisPatchScheduleInner get(String resourceGroupName, String name, DefaultName defaultParameter) {
        return (RedisPatchScheduleInner)((Object)this.getAsync(resourceGroupName, name, defaultParameter).block());
    }

    @Override
    public Response<RedisPatchScheduleInner> getWithResponse(String resourceGroupName, String name, DefaultName defaultParameter, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, name, defaultParameter, context).block();
    }

    private Mono<PagedResponse<RedisPatchScheduleInner>> listByRedisResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByRedisResourceNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisPatchScheduleListResult)res.getValue()).value(), ((RedisPatchScheduleListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<RedisPatchScheduleInner>> listByRedisResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByRedisResourceNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisPatchScheduleListResult)res.getValue()).value(), ((RedisPatchScheduleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RedisManagementClien")
    private static interface PatchSchedulesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/patchSchedules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisPatchScheduleListResult>> listByRedisResource(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cacheName") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisPatchScheduleInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="default") DefaultName var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") RedisPatchScheduleInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="default") DefaultName var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisPatchScheduleInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="default") DefaultName var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisPatchScheduleListResult>> listByRedisResourceNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

