/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerPropertiesForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfigForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cluster;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailabilityForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindowForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PostgresMajorVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SkuForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.Map;

public final class ServerForPatch
implements JsonSerializable<ServerForPatch> {
    private SkuForPatch sku;
    private UserAssignedIdentity identity;
    private ServerPropertiesForPatch innerProperties;
    private Map<String, String> tags;

    public SkuForPatch sku() {
        return this.sku;
    }

    public ServerForPatch withSku(SkuForPatch sku) {
        this.sku = sku;
        return this;
    }

    public UserAssignedIdentity identity() {
        return this.identity;
    }

    public ServerForPatch withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ServerPropertiesForPatch innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerForPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ServerForPatch withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerForPatch withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public PostgresMajorVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerForPatch withVersion(PostgresMajorVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    public ServerForPatch withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    public BackupForPatch backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    public ServerForPatch withBackup(BackupForPatch backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    public HighAvailabilityForPatch highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    public ServerForPatch withHighAvailability(HighAvailabilityForPatch highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    public MaintenanceWindowForPatch maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public ServerForPatch withMaintenanceWindow(MaintenanceWindowForPatch maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public AuthConfigForPatch authConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().authConfig();
    }

    public ServerForPatch withAuthConfig(AuthConfigForPatch authConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withAuthConfig(authConfig);
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    public ServerForPatch withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    public String availabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZone();
    }

    public ServerForPatch withAvailabilityZone(String availabilityZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withAvailabilityZone(availabilityZone);
        return this;
    }

    public CreateModeForPatch createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ServerForPatch withCreateMode(CreateModeForPatch createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerForPatch withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public Replica replica() {
        return this.innerProperties() == null ? null : this.innerProperties().replica();
    }

    public ServerForPatch withReplica(Replica replica) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withReplica(replica);
        return this;
    }

    public Network network() {
        return this.innerProperties() == null ? null : this.innerProperties().network();
    }

    public ServerForPatch withNetwork(Network network) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withNetwork(network);
        return this;
    }

    public Cluster cluster() {
        return this.innerProperties() == null ? null : this.innerProperties().cluster();
    }

    public ServerForPatch withCluster(Cluster cluster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForPatch();
        }
        this.innerProperties().withCluster(cluster);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ServerForPatch fromJson(JsonReader jsonReader) throws IOException {
        return (ServerForPatch)jsonReader.readObject(reader -> {
            ServerForPatch deserializedServerForPatch = new ServerForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedServerForPatch.sku = SkuForPatch.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedServerForPatch.identity = UserAssignedIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerForPatch.innerProperties = ServerPropertiesForPatch.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedServerForPatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerForPatch;
        });
    }
}

