/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReadReplicaPromoteMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReadReplicaPromoteOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationState;
import java.io.IOException;

public final class Replica
implements JsonSerializable<Replica> {
    private ReplicationRole role;
    private Integer capacity;
    private ReplicationState replicationState;
    private ReadReplicaPromoteMode promoteMode;
    private ReadReplicaPromoteOption promoteOption;

    public ReplicationRole role() {
        return this.role;
    }

    public Replica withRole(ReplicationRole role) {
        this.role = role;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public ReplicationState replicationState() {
        return this.replicationState;
    }

    public ReadReplicaPromoteMode promoteMode() {
        return this.promoteMode;
    }

    public Replica withPromoteMode(ReadReplicaPromoteMode promoteMode) {
        this.promoteMode = promoteMode;
        return this;
    }

    public ReadReplicaPromoteOption promoteOption() {
        return this.promoteOption;
    }

    public Replica withPromoteOption(ReadReplicaPromoteOption promoteOption) {
        this.promoteOption = promoteOption;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("promoteMode", this.promoteMode == null ? null : this.promoteMode.toString());
        jsonWriter.writeStringField("promoteOption", this.promoteOption == null ? null : this.promoteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static Replica fromJson(JsonReader jsonReader) throws IOException {
        return (Replica)jsonReader.readObject(reader -> {
            Replica deserializedReplica = new Replica();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    deserializedReplica.role = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedReplica.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("replicationState".equals(fieldName)) {
                    deserializedReplica.replicationState = ReplicationState.fromString(reader.getString());
                    continue;
                }
                if ("promoteMode".equals(fieldName)) {
                    deserializedReplica.promoteMode = ReadReplicaPromoteMode.fromString(reader.getString());
                    continue;
                }
                if ("promoteOption".equals(fieldName)) {
                    deserializedReplica.promoteOption = ReadReplicaPromoteOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplica;
        });
    }
}

