/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationPropertiesForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cancel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesAndPermissions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParametersForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDatabasesOnTargetServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutover;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class MigrationResourceForPatch
implements JsonSerializable<MigrationResourceForPatch> {
    private MigrationPropertiesForPatch innerProperties;
    private Map<String, String> tags;

    private MigrationPropertiesForPatch innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public MigrationResourceForPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String sourceDbServerResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDbServerResourceId();
    }

    public MigrationResourceForPatch withSourceDbServerResourceId(String sourceDbServerResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withSourceDbServerResourceId(sourceDbServerResourceId);
        return this;
    }

    public String sourceDbServerFullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDbServerFullyQualifiedDomainName();
    }

    public MigrationResourceForPatch withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withSourceDbServerFullyQualifiedDomainName(sourceDbServerFullyQualifiedDomainName);
        return this;
    }

    public String targetDbServerFullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDbServerFullyQualifiedDomainName();
    }

    public MigrationResourceForPatch withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withTargetDbServerFullyQualifiedDomainName(targetDbServerFullyQualifiedDomainName);
        return this;
    }

    public MigrationSecretParametersForPatch secretParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().secretParameters();
    }

    public MigrationResourceForPatch withSecretParameters(MigrationSecretParametersForPatch secretParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withSecretParameters(secretParameters);
        return this;
    }

    public List<String> dbsToMigrate() {
        return this.innerProperties() == null ? null : this.innerProperties().dbsToMigrate();
    }

    public MigrationResourceForPatch withDbsToMigrate(List<String> dbsToMigrate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withDbsToMigrate(dbsToMigrate);
        return this;
    }

    public LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.innerProperties() == null ? null : this.innerProperties().setupLogicalReplicationOnSourceDbIfNeeded();
    }

    public MigrationResourceForPatch withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withSetupLogicalReplicationOnSourceDbIfNeeded(setupLogicalReplicationOnSourceDbIfNeeded);
        return this;
    }

    public OverwriteDatabasesOnTargetServer overwriteDbsInTarget() {
        return this.innerProperties() == null ? null : this.innerProperties().overwriteDbsInTarget();
    }

    public MigrationResourceForPatch withOverwriteDbsInTarget(OverwriteDatabasesOnTargetServer overwriteDbsInTarget) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withOverwriteDbsInTarget(overwriteDbsInTarget);
        return this;
    }

    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationWindowStartTimeInUtc();
    }

    public MigrationResourceForPatch withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withMigrationWindowStartTimeInUtc(migrationWindowStartTimeInUtc);
        return this;
    }

    public MigrateRolesAndPermissions migrateRoles() {
        return this.innerProperties() == null ? null : this.innerProperties().migrateRoles();
    }

    public MigrationResourceForPatch withMigrateRoles(MigrateRolesAndPermissions migrateRoles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withMigrateRoles(migrateRoles);
        return this;
    }

    public StartDataMigration startDataMigration() {
        return this.innerProperties() == null ? null : this.innerProperties().startDataMigration();
    }

    public MigrationResourceForPatch withStartDataMigration(StartDataMigration startDataMigration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withStartDataMigration(startDataMigration);
        return this;
    }

    public TriggerCutover triggerCutover() {
        return this.innerProperties() == null ? null : this.innerProperties().triggerCutover();
    }

    public MigrationResourceForPatch withTriggerCutover(TriggerCutover triggerCutover) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withTriggerCutover(triggerCutover);
        return this;
    }

    public List<String> dbsToTriggerCutoverOn() {
        return this.innerProperties() == null ? null : this.innerProperties().dbsToTriggerCutoverOn();
    }

    public MigrationResourceForPatch withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withDbsToTriggerCutoverOn(dbsToTriggerCutoverOn);
        return this;
    }

    public Cancel cancel() {
        return this.innerProperties() == null ? null : this.innerProperties().cancel();
    }

    public MigrationResourceForPatch withCancel(Cancel cancel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withCancel(cancel);
        return this;
    }

    public List<String> dbsToCancelMigrationOn() {
        return this.innerProperties() == null ? null : this.innerProperties().dbsToCancelMigrationOn();
    }

    public MigrationResourceForPatch withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withDbsToCancelMigrationOn(dbsToCancelMigrationOn);
        return this;
    }

    public MigrationMode migrationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationMode();
    }

    public MigrationResourceForPatch withMigrationMode(MigrationMode migrationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationPropertiesForPatch();
        }
        this.innerProperties().withMigrationMode(migrationMode);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MigrationResourceForPatch fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationResourceForPatch)jsonReader.readObject(reader -> {
            MigrationResourceForPatch deserializedMigrationResourceForPatch = new MigrationResourceForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedMigrationResourceForPatch.innerProperties = MigrationPropertiesForPatch.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedMigrationResourceForPatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationResourceForPatch;
        });
    }
}

