/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationDatabaseState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DatabaseMigrationState
implements JsonSerializable<DatabaseMigrationState> {
    private String databaseName;
    private MigrationDatabaseState migrationState;
    private String migrationOperation;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private Integer fullLoadQueuedTables;
    private Integer fullLoadErroredTables;
    private Integer fullLoadLoadingTables;
    private Integer fullLoadCompletedTables;
    private Integer cdcUpdateCounter;
    private Integer cdcDeleteCounter;
    private Integer cdcInsertCounter;
    private Integer appliedChanges;
    private Integer incomingChanges;
    private Integer latency;
    private String message;

    public String databaseName() {
        return this.databaseName;
    }

    public DatabaseMigrationState withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public MigrationDatabaseState migrationState() {
        return this.migrationState;
    }

    public DatabaseMigrationState withMigrationState(MigrationDatabaseState migrationState) {
        this.migrationState = migrationState;
        return this;
    }

    public String migrationOperation() {
        return this.migrationOperation;
    }

    public DatabaseMigrationState withMigrationOperation(String migrationOperation) {
        this.migrationOperation = migrationOperation;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public DatabaseMigrationState withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public DatabaseMigrationState withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    public Integer fullLoadQueuedTables() {
        return this.fullLoadQueuedTables;
    }

    public DatabaseMigrationState withFullLoadQueuedTables(Integer fullLoadQueuedTables) {
        this.fullLoadQueuedTables = fullLoadQueuedTables;
        return this;
    }

    public Integer fullLoadErroredTables() {
        return this.fullLoadErroredTables;
    }

    public DatabaseMigrationState withFullLoadErroredTables(Integer fullLoadErroredTables) {
        this.fullLoadErroredTables = fullLoadErroredTables;
        return this;
    }

    public Integer fullLoadLoadingTables() {
        return this.fullLoadLoadingTables;
    }

    public DatabaseMigrationState withFullLoadLoadingTables(Integer fullLoadLoadingTables) {
        this.fullLoadLoadingTables = fullLoadLoadingTables;
        return this;
    }

    public Integer fullLoadCompletedTables() {
        return this.fullLoadCompletedTables;
    }

    public DatabaseMigrationState withFullLoadCompletedTables(Integer fullLoadCompletedTables) {
        this.fullLoadCompletedTables = fullLoadCompletedTables;
        return this;
    }

    public Integer cdcUpdateCounter() {
        return this.cdcUpdateCounter;
    }

    public DatabaseMigrationState withCdcUpdateCounter(Integer cdcUpdateCounter) {
        this.cdcUpdateCounter = cdcUpdateCounter;
        return this;
    }

    public Integer cdcDeleteCounter() {
        return this.cdcDeleteCounter;
    }

    public DatabaseMigrationState withCdcDeleteCounter(Integer cdcDeleteCounter) {
        this.cdcDeleteCounter = cdcDeleteCounter;
        return this;
    }

    public Integer cdcInsertCounter() {
        return this.cdcInsertCounter;
    }

    public DatabaseMigrationState withCdcInsertCounter(Integer cdcInsertCounter) {
        this.cdcInsertCounter = cdcInsertCounter;
        return this;
    }

    public Integer appliedChanges() {
        return this.appliedChanges;
    }

    public DatabaseMigrationState withAppliedChanges(Integer appliedChanges) {
        this.appliedChanges = appliedChanges;
        return this;
    }

    public Integer incomingChanges() {
        return this.incomingChanges;
    }

    public DatabaseMigrationState withIncomingChanges(Integer incomingChanges) {
        this.incomingChanges = incomingChanges;
        return this;
    }

    public Integer latency() {
        return this.latency;
    }

    public DatabaseMigrationState withLatency(Integer latency) {
        this.latency = latency;
        return this;
    }

    public String message() {
        return this.message;
    }

    public DatabaseMigrationState withMessage(String message) {
        this.message = message;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("migrationState", this.migrationState == null ? null : this.migrationState.toString());
        jsonWriter.writeStringField("migrationOperation", this.migrationOperation);
        jsonWriter.writeStringField("startedOn", this.startedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedOn));
        jsonWriter.writeStringField("endedOn", this.endedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endedOn));
        jsonWriter.writeNumberField("fullLoadQueuedTables", (Number)this.fullLoadQueuedTables);
        jsonWriter.writeNumberField("fullLoadErroredTables", (Number)this.fullLoadErroredTables);
        jsonWriter.writeNumberField("fullLoadLoadingTables", (Number)this.fullLoadLoadingTables);
        jsonWriter.writeNumberField("fullLoadCompletedTables", (Number)this.fullLoadCompletedTables);
        jsonWriter.writeNumberField("cdcUpdateCounter", (Number)this.cdcUpdateCounter);
        jsonWriter.writeNumberField("cdcDeleteCounter", (Number)this.cdcDeleteCounter);
        jsonWriter.writeNumberField("cdcInsertCounter", (Number)this.cdcInsertCounter);
        jsonWriter.writeNumberField("appliedChanges", (Number)this.appliedChanges);
        jsonWriter.writeNumberField("incomingChanges", (Number)this.incomingChanges);
        jsonWriter.writeNumberField("latency", (Number)this.latency);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationState fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationState)jsonReader.readObject(reader -> {
            DatabaseMigrationState deserializedDatabaseMigrationState = new DatabaseMigrationState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDatabaseMigrationState.databaseName = reader.getString();
                    continue;
                }
                if ("migrationState".equals(fieldName)) {
                    deserializedDatabaseMigrationState.migrationState = MigrationDatabaseState.fromString(reader.getString());
                    continue;
                }
                if ("migrationOperation".equals(fieldName)) {
                    deserializedDatabaseMigrationState.migrationOperation = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationState.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationState.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fullLoadQueuedTables".equals(fieldName)) {
                    deserializedDatabaseMigrationState.fullLoadQueuedTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullLoadErroredTables".equals(fieldName)) {
                    deserializedDatabaseMigrationState.fullLoadErroredTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullLoadLoadingTables".equals(fieldName)) {
                    deserializedDatabaseMigrationState.fullLoadLoadingTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullLoadCompletedTables".equals(fieldName)) {
                    deserializedDatabaseMigrationState.fullLoadCompletedTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cdcUpdateCounter".equals(fieldName)) {
                    deserializedDatabaseMigrationState.cdcUpdateCounter = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cdcDeleteCounter".equals(fieldName)) {
                    deserializedDatabaseMigrationState.cdcDeleteCounter = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cdcInsertCounter".equals(fieldName)) {
                    deserializedDatabaseMigrationState.cdcInsertCounter = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("appliedChanges".equals(fieldName)) {
                    deserializedDatabaseMigrationState.appliedChanges = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("incomingChanges".equals(fieldName)) {
                    deserializedDatabaseMigrationState.incomingChanges = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("latency".equals(fieldName)) {
                    deserializedDatabaseMigrationState.latency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDatabaseMigrationState.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationState;
        });
    }
}

