/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.GeographicallyRedundantBackup;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BackupForPatch
implements JsonSerializable<BackupForPatch> {
    private Integer backupRetentionDays;
    private GeographicallyRedundantBackup geoRedundantBackup;
    private OffsetDateTime earliestRestoreDate;

    public Integer backupRetentionDays() {
        return this.backupRetentionDays;
    }

    public BackupForPatch withBackupRetentionDays(Integer backupRetentionDays) {
        this.backupRetentionDays = backupRetentionDays;
        return this;
    }

    public GeographicallyRedundantBackup geoRedundantBackup() {
        return this.geoRedundantBackup;
    }

    public BackupForPatch withGeoRedundantBackup(GeographicallyRedundantBackup geoRedundantBackup) {
        this.geoRedundantBackup = geoRedundantBackup;
        return this;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("backupRetentionDays", (Number)this.backupRetentionDays);
        jsonWriter.writeStringField("geoRedundantBackup", this.geoRedundantBackup == null ? null : this.geoRedundantBackup.toString());
        return jsonWriter.writeEndObject();
    }

    public static BackupForPatch fromJson(JsonReader jsonReader) throws IOException {
        return (BackupForPatch)jsonReader.readObject(reader -> {
            BackupForPatch deserializedBackupForPatch = new BackupForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupRetentionDays".equals(fieldName)) {
                    deserializedBackupForPatch.backupRetentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("geoRedundantBackup".equals(fieldName)) {
                    deserializedBackupForPatch.geoRedundantBackup = GeographicallyRedundantBackup.fromString(reader.getString());
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedBackupForPatch.earliestRestoreDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupForPatch;
        });
    }
}

