/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualEndpointsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualEndpointImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpoint;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpoints;

public final class VirtualEndpointsImpl
implements VirtualEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualEndpointsImpl.class);
    private final VirtualEndpointsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public VirtualEndpointsImpl(VirtualEndpointsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String virtualEndpointName) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualEndpointName);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String virtualEndpointName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualEndpointName, context);
    }

    @Override
    public Response<VirtualEndpoint> getWithResponse(String resourceGroupName, String serverName, String virtualEndpointName, Context context) {
        Response<VirtualEndpointInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, virtualEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualEndpointImpl((VirtualEndpointInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualEndpoint get(String resourceGroupName, String serverName, String virtualEndpointName) {
        VirtualEndpointInner inner = this.serviceClient().get(resourceGroupName, serverName, virtualEndpointName);
        if (inner != null) {
            return new VirtualEndpointImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<VirtualEndpoint> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<VirtualEndpointInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualEndpointImpl((VirtualEndpointInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<VirtualEndpoint> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<VirtualEndpointInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualEndpointImpl((VirtualEndpointInner)inner1, this.manager()));
    }

    @Override
    public VirtualEndpoint getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        return (VirtualEndpoint)this.getWithResponse(resourceGroupName, serverName, virtualEndpointName, Context.NONE).getValue();
    }

    @Override
    public Response<VirtualEndpoint> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, virtualEndpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualEndpointName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualEndpointName, context);
    }

    private VirtualEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualEndpointImpl define(String name) {
        return new VirtualEndpointImpl(name, this.manager());
    }
}

