/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpoint;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointType;
import java.util.Collections;
import java.util.List;

public final class VirtualEndpointImpl
implements VirtualEndpoint,
VirtualEndpoint.Definition,
VirtualEndpoint.Update {
    private VirtualEndpointInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String virtualEndpointName;
    private VirtualEndpointResourceForPatch updateParameters;

    @Override
    public VirtualEndpointType endpointType() {
        return this.innerModel().endpointType();
    }

    @Override
    public List<String> members() {
        List<String> inner = this.innerModel().members();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> virtualEndpoints() {
        List<String> inner = this.innerModel().virtualEndpoints();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VirtualEndpointInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualEndpointImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public VirtualEndpoint create() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualEndpoints().create(this.resourceGroupName, this.serverName, this.virtualEndpointName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VirtualEndpoint create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualEndpoints().create(this.resourceGroupName, this.serverName, this.virtualEndpointName, this.innerModel(), context);
        return this;
    }

    VirtualEndpointImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new VirtualEndpointInner();
        this.serviceManager = serviceManager;
        this.virtualEndpointName = name;
    }

    @Override
    public VirtualEndpointImpl update() {
        this.updateParameters = new VirtualEndpointResourceForPatch();
        return this;
    }

    @Override
    public VirtualEndpoint apply() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualEndpoints().update(this.resourceGroupName, this.serverName, this.virtualEndpointName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public VirtualEndpoint apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualEndpoints().update(this.resourceGroupName, this.serverName, this.virtualEndpointName, this.updateParameters, context);
        return this;
    }

    VirtualEndpointImpl(VirtualEndpointInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualendpoints");
    }

    @Override
    public VirtualEndpoint refresh() {
        this.innerObject = (VirtualEndpointInner)this.serviceManager.serviceClient().getVirtualEndpoints().getWithResponse(this.resourceGroupName, this.serverName, this.virtualEndpointName, Context.NONE).getValue();
        return this;
    }

    @Override
    public VirtualEndpoint refresh(Context context) {
        this.innerObject = (VirtualEndpointInner)this.serviceManager.serviceClient().getVirtualEndpoints().getWithResponse(this.resourceGroupName, this.serverName, this.virtualEndpointName, context).getValue();
        return this;
    }

    @Override
    public VirtualEndpointImpl withEndpointType(VirtualEndpointType endpointType) {
        if (this.isInCreateMode()) {
            this.innerModel().withEndpointType(endpointType);
            return this;
        }
        this.updateParameters.withEndpointType(endpointType);
        return this;
    }

    @Override
    public VirtualEndpointImpl withMembers(List<String> members) {
        if (this.isInCreateMode()) {
            this.innerModel().withMembers((List)members);
            return this;
        }
        this.updateParameters.withMembers(members);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

