/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.TuningOptionsOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ObjectRecommendationInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.TuningOptionsInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ObjectRecommendationImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.TuningOptionsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ObjectRecommendation;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RecommendationTypeParameterEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionParameterEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionsOperations;

public final class TuningOptionsOperationsImpl
implements TuningOptionsOperations {
    private static final ClientLogger LOGGER = new ClientLogger(TuningOptionsOperationsImpl.class);
    private final TuningOptionsOperationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public TuningOptionsOperationsImpl(TuningOptionsOperationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<TuningOptions> getWithResponse(String resourceGroupName, String serverName, TuningOptionParameterEnum tuningOption, Context context) {
        Response<TuningOptionsInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, tuningOption, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TuningOptionsImpl((TuningOptionsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TuningOptions get(String resourceGroupName, String serverName, TuningOptionParameterEnum tuningOption) {
        TuningOptionsInner inner = this.serviceClient().get(resourceGroupName, serverName, tuningOption);
        if (inner != null) {
            return new TuningOptionsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ObjectRecommendation> listRecommendations(String resourceGroupName, String serverName, TuningOptionParameterEnum tuningOption) {
        PagedIterable<ObjectRecommendationInner> inner = this.serviceClient().listRecommendations(resourceGroupName, serverName, tuningOption);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ObjectRecommendationImpl((ObjectRecommendationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ObjectRecommendation> listRecommendations(String resourceGroupName, String serverName, TuningOptionParameterEnum tuningOption, RecommendationTypeParameterEnum recommendationType, Context context) {
        PagedIterable<ObjectRecommendationInner> inner = this.serviceClient().listRecommendations(resourceGroupName, serverName, tuningOption, recommendationType, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ObjectRecommendationImpl((ObjectRecommendationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TuningOptions> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<TuningOptionsInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TuningOptionsImpl((TuningOptionsInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TuningOptions> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<TuningOptionsInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TuningOptionsImpl((TuningOptionsInner)((Object)inner1), this.manager()));
    }

    private TuningOptionsOperationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

