/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdministratorsMicrosoftEntrasClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdvancedThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.BackupsAutomaticAndOnDemandsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.BackupsLongTermRetentionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CapabilitiesByLocationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CapabilitiesByServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CapturedLogsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ConfigurationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.DatabasesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.FirewallRulesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.NameAvailabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.OperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PostgreSqlManagementClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateDnsZoneSuffixesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.QuotaUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ReplicasClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.TuningOptionsOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualEndpointsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualNetworkSubnetUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdministratorsMicrosoftEntrasClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdvancedThreatProtectionSettingsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsAutomaticAndOnDemandsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsLongTermRetentionsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapabilitiesByLocationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapabilitiesByServersClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapturedLogsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ConfigurationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.DatabasesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.FirewallRulesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.NameAvailabilitiesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.OperationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientBuilder;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateDnsZoneSuffixesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.QuotaUsagesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ReplicasClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServerThreatProtectionSettingsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServersClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.TuningOptionsOperationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualEndpointsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualNetworkSubnetUsagesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PostgreSqlManagementClientBuilder.class)
public final class PostgreSqlManagementClientImpl
implements PostgreSqlManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AdministratorsMicrosoftEntrasClient administratorsMicrosoftEntras;
    private final AdvancedThreatProtectionSettingsClient advancedThreatProtectionSettings;
    private final ServerThreatProtectionSettingsClient serverThreatProtectionSettings;
    private final BackupsAutomaticAndOnDemandsClient backupsAutomaticAndOnDemands;
    private final CapabilitiesByLocationsClient capabilitiesByLocations;
    private final CapabilitiesByServersClient capabilitiesByServers;
    private final CapturedLogsClient capturedLogs;
    private final ConfigurationsClient configurations;
    private final DatabasesClient databases;
    private final FirewallRulesClient firewallRules;
    private final BackupsLongTermRetentionsClient backupsLongTermRetentions;
    private final MigrationsClient migrations;
    private final NameAvailabilitiesClient nameAvailabilities;
    private final OperationsClient operations;
    private final PrivateDnsZoneSuffixesClient privateDnsZoneSuffixes;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final QuotaUsagesClient quotaUsages;
    private final ReplicasClient replicas;
    private final ServersClient servers;
    private final TuningOptionsOperationsClient tuningOptionsOperations;
    private final VirtualEndpointsClient virtualEndpoints;
    private final VirtualNetworkSubnetUsagesClient virtualNetworkSubnetUsages;
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AdministratorsMicrosoftEntrasClient getAdministratorsMicrosoftEntras() {
        return this.administratorsMicrosoftEntras;
    }

    @Override
    public AdvancedThreatProtectionSettingsClient getAdvancedThreatProtectionSettings() {
        return this.advancedThreatProtectionSettings;
    }

    @Override
    public ServerThreatProtectionSettingsClient getServerThreatProtectionSettings() {
        return this.serverThreatProtectionSettings;
    }

    @Override
    public BackupsAutomaticAndOnDemandsClient getBackupsAutomaticAndOnDemands() {
        return this.backupsAutomaticAndOnDemands;
    }

    @Override
    public CapabilitiesByLocationsClient getCapabilitiesByLocations() {
        return this.capabilitiesByLocations;
    }

    @Override
    public CapabilitiesByServersClient getCapabilitiesByServers() {
        return this.capabilitiesByServers;
    }

    @Override
    public CapturedLogsClient getCapturedLogs() {
        return this.capturedLogs;
    }

    @Override
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    @Override
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    @Override
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    @Override
    public BackupsLongTermRetentionsClient getBackupsLongTermRetentions() {
        return this.backupsLongTermRetentions;
    }

    @Override
    public MigrationsClient getMigrations() {
        return this.migrations;
    }

    @Override
    public NameAvailabilitiesClient getNameAvailabilities() {
        return this.nameAvailabilities;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public PrivateDnsZoneSuffixesClient getPrivateDnsZoneSuffixes() {
        return this.privateDnsZoneSuffixes;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public QuotaUsagesClient getQuotaUsages() {
        return this.quotaUsages;
    }

    @Override
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    @Override
    public ServersClient getServers() {
        return this.servers;
    }

    @Override
    public TuningOptionsOperationsClient getTuningOptionsOperations() {
        return this.tuningOptionsOperations;
    }

    @Override
    public VirtualEndpointsClient getVirtualEndpoints() {
        return this.virtualEndpoints;
    }

    @Override
    public VirtualNetworkSubnetUsagesClient getVirtualNetworkSubnetUsages() {
        return this.virtualNetworkSubnetUsages;
    }

    PostgreSqlManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-08-01";
        this.administratorsMicrosoftEntras = new AdministratorsMicrosoftEntrasClientImpl(this);
        this.advancedThreatProtectionSettings = new AdvancedThreatProtectionSettingsClientImpl(this);
        this.serverThreatProtectionSettings = new ServerThreatProtectionSettingsClientImpl(this);
        this.backupsAutomaticAndOnDemands = new BackupsAutomaticAndOnDemandsClientImpl(this);
        this.capabilitiesByLocations = new CapabilitiesByLocationsClientImpl(this);
        this.capabilitiesByServers = new CapabilitiesByServersClientImpl(this);
        this.capturedLogs = new CapturedLogsClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.backupsLongTermRetentions = new BackupsLongTermRetentionsClientImpl(this);
        this.migrations = new MigrationsClientImpl(this);
        this.nameAvailabilities = new NameAvailabilitiesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.privateDnsZoneSuffixes = new PrivateDnsZoneSuffixesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.quotaUsages = new QuotaUsagesClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.servers = new ServersClientImpl(this);
        this.tuningOptionsOperations = new TuningOptionsOperationsClientImpl(this);
        this.virtualEndpoints = new VirtualEndpointsClientImpl(this);
        this.virtualNetworkSubnetUsages = new VirtualNetworkSubnetUsagesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

