/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationNameAvailabilityInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationNameAvailabilityImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Migration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationListFilter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationNameAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Migrations;

public final class MigrationsImpl
implements Migrations {
    private static final ClientLogger LOGGER = new ClientLogger(MigrationsImpl.class);
    private final MigrationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public MigrationsImpl(MigrationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Migration> getWithResponse(String resourceGroupName, String serverName, String migrationName, Context context) {
        Response<MigrationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, migrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MigrationImpl((MigrationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Migration get(String resourceGroupName, String serverName, String migrationName) {
        MigrationInner inner = this.serviceClient().get(resourceGroupName, serverName, migrationName);
        if (inner != null) {
            return new MigrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Migration> cancelWithResponse(String resourceGroupName, String serverName, String migrationName, Context context) {
        Response<MigrationInner> inner = this.serviceClient().cancelWithResponse(resourceGroupName, serverName, migrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MigrationImpl((MigrationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Migration cancel(String resourceGroupName, String serverName, String migrationName) {
        MigrationInner inner = this.serviceClient().cancel(resourceGroupName, serverName, migrationName);
        if (inner != null) {
            return new MigrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Migration> listByTargetServer(String resourceGroupName, String serverName) {
        PagedIterable<MigrationInner> inner = this.serviceClient().listByTargetServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationImpl((MigrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Migration> listByTargetServer(String resourceGroupName, String serverName, MigrationListFilter migrationListFilter, Context context) {
        PagedIterable<MigrationInner> inner = this.serviceClient().listByTargetServer(resourceGroupName, serverName, migrationListFilter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationImpl((MigrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<MigrationNameAvailability> checkNameAvailabilityWithResponse(String resourceGroupName, String serverName, MigrationNameAvailabilityInner parameters, Context context) {
        Response<MigrationNameAvailabilityInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, serverName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MigrationNameAvailabilityImpl((MigrationNameAvailabilityInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public MigrationNameAvailability checkNameAvailability(String resourceGroupName, String serverName, MigrationNameAvailabilityInner parameters) {
        MigrationNameAvailabilityInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, serverName, parameters);
        if (inner != null) {
            return new MigrationNameAvailabilityImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Migration getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "migrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrations'.", id)));
        }
        return (Migration)this.getWithResponse(resourceGroupName, serverName, migrationName, Context.NONE).getValue();
    }

    @Override
    public Response<Migration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "migrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, migrationName, context);
    }

    private MigrationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public MigrationImpl define(String name) {
        return new MigrationImpl(name, this.manager());
    }
}

