/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CapturedLogsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.CapturedLogInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapturedLogImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapturedLog;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapturedLogs;

public final class CapturedLogsImpl
implements CapturedLogs {
    private static final ClientLogger LOGGER = new ClientLogger(CapturedLogsImpl.class);
    private final CapturedLogsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public CapturedLogsImpl(CapturedLogsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CapturedLog> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<CapturedLogInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapturedLogImpl((CapturedLogInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CapturedLog> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<CapturedLogInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapturedLogImpl((CapturedLogInner)((Object)inner1), this.manager()));
    }

    private CapturedLogsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

