/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CapabilitiesByLocationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.CapabilityInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapabilityImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilitiesByLocations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Capability;

public final class CapabilitiesByLocationsImpl
implements CapabilitiesByLocations {
    private static final ClientLogger LOGGER = new ClientLogger(CapabilitiesByLocationsImpl.class);
    private final CapabilitiesByLocationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public CapabilitiesByLocationsImpl(CapabilitiesByLocationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Capability> list(String locationName) {
        PagedIterable<CapabilityInner> inner = this.serviceClient().list(locationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityImpl((CapabilityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Capability> list(String locationName, Context context) {
        PagedIterable<CapabilityInner> inner = this.serviceClient().list(locationName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityImpl((CapabilityInner)inner1, this.manager()));
    }

    private CapabilitiesByLocationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

