/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdvancedThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.AdvancedThreatProtectionSettingsModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdvancedThreatProtectionSettingsModelImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdvancedThreatProtectionSettings;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdvancedThreatProtectionSettingsModel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionName;

public final class AdvancedThreatProtectionSettingsImpl
implements AdvancedThreatProtectionSettings {
    private static final ClientLogger LOGGER = new ClientLogger(AdvancedThreatProtectionSettingsImpl.class);
    private final AdvancedThreatProtectionSettingsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public AdvancedThreatProtectionSettingsImpl(AdvancedThreatProtectionSettingsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AdvancedThreatProtectionSettingsModel> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<AdvancedThreatProtectionSettingsModelInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AdvancedThreatProtectionSettingsModelImpl((AdvancedThreatProtectionSettingsModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AdvancedThreatProtectionSettingsModel> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<AdvancedThreatProtectionSettingsModelInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AdvancedThreatProtectionSettingsModelImpl((AdvancedThreatProtectionSettingsModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AdvancedThreatProtectionSettingsModel> getWithResponse(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, Context context) {
        Response<AdvancedThreatProtectionSettingsModelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, threatProtectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AdvancedThreatProtectionSettingsModelImpl((AdvancedThreatProtectionSettingsModelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AdvancedThreatProtectionSettingsModel get(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName) {
        AdvancedThreatProtectionSettingsModelInner inner = this.serviceClient().get(resourceGroupName, serverName, threatProtectionName);
        if (inner != null) {
            return new AdvancedThreatProtectionSettingsModelImpl(inner, this.manager());
        }
        return null;
    }

    private AdvancedThreatProtectionSettingsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

