/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ImpactRecord;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ObjectRecommendationDetails;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ObjectRecommendationPropertiesAnalyzedWorkload;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ObjectRecommendationPropertiesImplementationDetails;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RecommendationTypeEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ObjectRecommendationProperties
implements JsonSerializable<ObjectRecommendationProperties> {
    private OffsetDateTime initialRecommendedTime;
    private OffsetDateTime lastRecommendedTime;
    private Integer timesRecommended;
    private List<Long> improvedQueryIds;
    private String recommendationReason;
    private String currentState;
    private RecommendationTypeEnum recommendationType;
    private ObjectRecommendationPropertiesImplementationDetails implementationDetails;
    private ObjectRecommendationPropertiesAnalyzedWorkload analyzedWorkload;
    private List<ImpactRecord> estimatedImpact;
    private ObjectRecommendationDetails details;

    public OffsetDateTime initialRecommendedTime() {
        return this.initialRecommendedTime;
    }

    public ObjectRecommendationProperties withInitialRecommendedTime(OffsetDateTime initialRecommendedTime) {
        this.initialRecommendedTime = initialRecommendedTime;
        return this;
    }

    public OffsetDateTime lastRecommendedTime() {
        return this.lastRecommendedTime;
    }

    public ObjectRecommendationProperties withLastRecommendedTime(OffsetDateTime lastRecommendedTime) {
        this.lastRecommendedTime = lastRecommendedTime;
        return this;
    }

    public Integer timesRecommended() {
        return this.timesRecommended;
    }

    public ObjectRecommendationProperties withTimesRecommended(Integer timesRecommended) {
        this.timesRecommended = timesRecommended;
        return this;
    }

    public List<Long> improvedQueryIds() {
        return this.improvedQueryIds;
    }

    public ObjectRecommendationProperties withImprovedQueryIds(List<Long> improvedQueryIds) {
        this.improvedQueryIds = improvedQueryIds;
        return this;
    }

    public String recommendationReason() {
        return this.recommendationReason;
    }

    public ObjectRecommendationProperties withRecommendationReason(String recommendationReason) {
        this.recommendationReason = recommendationReason;
        return this;
    }

    public String currentState() {
        return this.currentState;
    }

    public ObjectRecommendationProperties withCurrentState(String currentState) {
        this.currentState = currentState;
        return this;
    }

    public RecommendationTypeEnum recommendationType() {
        return this.recommendationType;
    }

    public ObjectRecommendationProperties withRecommendationType(RecommendationTypeEnum recommendationType) {
        this.recommendationType = recommendationType;
        return this;
    }

    public ObjectRecommendationPropertiesImplementationDetails implementationDetails() {
        return this.implementationDetails;
    }

    public ObjectRecommendationProperties withImplementationDetails(ObjectRecommendationPropertiesImplementationDetails implementationDetails) {
        this.implementationDetails = implementationDetails;
        return this;
    }

    public ObjectRecommendationPropertiesAnalyzedWorkload analyzedWorkload() {
        return this.analyzedWorkload;
    }

    public ObjectRecommendationProperties withAnalyzedWorkload(ObjectRecommendationPropertiesAnalyzedWorkload analyzedWorkload) {
        this.analyzedWorkload = analyzedWorkload;
        return this;
    }

    public List<ImpactRecord> estimatedImpact() {
        return this.estimatedImpact;
    }

    public ObjectRecommendationDetails details() {
        return this.details;
    }

    public void validate() {
        if (this.implementationDetails() != null) {
            this.implementationDetails().validate();
        }
        if (this.analyzedWorkload() != null) {
            this.analyzedWorkload().validate();
        }
        if (this.estimatedImpact() != null) {
            this.estimatedImpact().forEach(e -> e.validate());
        }
        if (this.details() != null) {
            this.details().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("initialRecommendedTime", this.initialRecommendedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.initialRecommendedTime));
        jsonWriter.writeStringField("lastRecommendedTime", this.lastRecommendedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastRecommendedTime));
        jsonWriter.writeNumberField("timesRecommended", (Number)this.timesRecommended);
        jsonWriter.writeArrayField("improvedQueryIds", this.improvedQueryIds, (writer, element) -> writer.writeLong(element.longValue()));
        jsonWriter.writeStringField("recommendationReason", this.recommendationReason);
        jsonWriter.writeStringField("currentState", this.currentState);
        jsonWriter.writeStringField("recommendationType", this.recommendationType == null ? null : this.recommendationType.toString());
        jsonWriter.writeJsonField("implementationDetails", (JsonSerializable)this.implementationDetails);
        jsonWriter.writeJsonField("analyzedWorkload", (JsonSerializable)this.analyzedWorkload);
        return jsonWriter.writeEndObject();
    }

    public static ObjectRecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ObjectRecommendationProperties)jsonReader.readObject(reader -> {
            ObjectRecommendationProperties deserializedObjectRecommendationProperties = new ObjectRecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("initialRecommendedTime".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.initialRecommendedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastRecommendedTime".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.lastRecommendedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timesRecommended".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.timesRecommended = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("improvedQueryIds".equals(fieldName)) {
                    List improvedQueryIds;
                    deserializedObjectRecommendationProperties.improvedQueryIds = improvedQueryIds = reader.readArray(reader1 -> reader1.getLong());
                    continue;
                }
                if ("recommendationReason".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.recommendationReason = reader.getString();
                    continue;
                }
                if ("currentState".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.currentState = reader.getString();
                    continue;
                }
                if ("recommendationType".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.recommendationType = RecommendationTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("implementationDetails".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.implementationDetails = ObjectRecommendationPropertiesImplementationDetails.fromJson(reader);
                    continue;
                }
                if ("analyzedWorkload".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.analyzedWorkload = ObjectRecommendationPropertiesAnalyzedWorkload.fromJson(reader);
                    continue;
                }
                if ("estimatedImpact".equals(fieldName)) {
                    List estimatedImpact;
                    deserializedObjectRecommendationProperties.estimatedImpact = estimatedImpact = reader.readArray(reader1 -> ImpactRecord.fromJson(reader1));
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedObjectRecommendationProperties.details = ObjectRecommendationDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedObjectRecommendationProperties;
        });
    }
}

