/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cancel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbServerMetadata;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesAndPermissions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDatabasesOnTargetServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SourceType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SslMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutover;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class MigrationProperties
implements JsonSerializable<MigrationProperties> {
    private String migrationId;
    private MigrationStatus currentStatus;
    private String migrationInstanceResourceId;
    private MigrationMode migrationMode;
    private MigrationOption migrationOption;
    private SourceType sourceType;
    private SslMode sslMode;
    private DbServerMetadata sourceDbServerMetadata;
    private DbServerMetadata targetDbServerMetadata;
    private String sourceDbServerResourceId;
    private String sourceDbServerFullyQualifiedDomainName;
    private String targetDbServerResourceId;
    private String targetDbServerFullyQualifiedDomainName;
    private MigrationSecretParameters secretParameters;
    private List<String> dbsToMigrate;
    private LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded;
    private OverwriteDatabasesOnTargetServer overwriteDbsInTarget;
    private OffsetDateTime migrationWindowStartTimeInUtc;
    private OffsetDateTime migrationWindowEndTimeInUtc;
    private MigrateRolesAndPermissions migrateRoles;
    private StartDataMigration startDataMigration;
    private TriggerCutover triggerCutover;
    private List<String> dbsToTriggerCutoverOn;
    private Cancel cancel;
    private List<String> dbsToCancelMigrationOn;

    public String migrationId() {
        return this.migrationId;
    }

    public MigrationStatus currentStatus() {
        return this.currentStatus;
    }

    public String migrationInstanceResourceId() {
        return this.migrationInstanceResourceId;
    }

    public MigrationProperties withMigrationInstanceResourceId(String migrationInstanceResourceId) {
        this.migrationInstanceResourceId = migrationInstanceResourceId;
        return this;
    }

    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    public MigrationProperties withMigrationMode(MigrationMode migrationMode) {
        this.migrationMode = migrationMode;
        return this;
    }

    public MigrationOption migrationOption() {
        return this.migrationOption;
    }

    public MigrationProperties withMigrationOption(MigrationOption migrationOption) {
        this.migrationOption = migrationOption;
        return this;
    }

    public SourceType sourceType() {
        return this.sourceType;
    }

    public MigrationProperties withSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public SslMode sslMode() {
        return this.sslMode;
    }

    public MigrationProperties withSslMode(SslMode sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public DbServerMetadata sourceDbServerMetadata() {
        return this.sourceDbServerMetadata;
    }

    public DbServerMetadata targetDbServerMetadata() {
        return this.targetDbServerMetadata;
    }

    public String sourceDbServerResourceId() {
        return this.sourceDbServerResourceId;
    }

    public MigrationProperties withSourceDbServerResourceId(String sourceDbServerResourceId) {
        this.sourceDbServerResourceId = sourceDbServerResourceId;
        return this;
    }

    public String sourceDbServerFullyQualifiedDomainName() {
        return this.sourceDbServerFullyQualifiedDomainName;
    }

    public MigrationProperties withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        this.sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName;
        return this;
    }

    public String targetDbServerResourceId() {
        return this.targetDbServerResourceId;
    }

    public String targetDbServerFullyQualifiedDomainName() {
        return this.targetDbServerFullyQualifiedDomainName;
    }

    public MigrationProperties withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        this.targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName;
        return this;
    }

    public MigrationSecretParameters secretParameters() {
        return this.secretParameters;
    }

    public MigrationProperties withSecretParameters(MigrationSecretParameters secretParameters) {
        this.secretParameters = secretParameters;
        return this;
    }

    public List<String> dbsToMigrate() {
        return this.dbsToMigrate;
    }

    public MigrationProperties withDbsToMigrate(List<String> dbsToMigrate) {
        this.dbsToMigrate = dbsToMigrate;
        return this;
    }

    public LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.setupLogicalReplicationOnSourceDbIfNeeded;
    }

    public MigrationProperties withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded;
        return this;
    }

    public OverwriteDatabasesOnTargetServer overwriteDbsInTarget() {
        return this.overwriteDbsInTarget;
    }

    public MigrationProperties withOverwriteDbsInTarget(OverwriteDatabasesOnTargetServer overwriteDbsInTarget) {
        this.overwriteDbsInTarget = overwriteDbsInTarget;
        return this;
    }

    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.migrationWindowStartTimeInUtc;
    }

    public MigrationProperties withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        this.migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc;
        return this;
    }

    public OffsetDateTime migrationWindowEndTimeInUtc() {
        return this.migrationWindowEndTimeInUtc;
    }

    public MigrationProperties withMigrationWindowEndTimeInUtc(OffsetDateTime migrationWindowEndTimeInUtc) {
        this.migrationWindowEndTimeInUtc = migrationWindowEndTimeInUtc;
        return this;
    }

    public MigrateRolesAndPermissions migrateRoles() {
        return this.migrateRoles;
    }

    public MigrationProperties withMigrateRoles(MigrateRolesAndPermissions migrateRoles) {
        this.migrateRoles = migrateRoles;
        return this;
    }

    public StartDataMigration startDataMigration() {
        return this.startDataMigration;
    }

    public MigrationProperties withStartDataMigration(StartDataMigration startDataMigration) {
        this.startDataMigration = startDataMigration;
        return this;
    }

    public TriggerCutover triggerCutover() {
        return this.triggerCutover;
    }

    public MigrationProperties withTriggerCutover(TriggerCutover triggerCutover) {
        this.triggerCutover = triggerCutover;
        return this;
    }

    public List<String> dbsToTriggerCutoverOn() {
        return this.dbsToTriggerCutoverOn;
    }

    public MigrationProperties withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        this.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
        return this;
    }

    public Cancel cancel() {
        return this.cancel;
    }

    public MigrationProperties withCancel(Cancel cancel) {
        this.cancel = cancel;
        return this;
    }

    public List<String> dbsToCancelMigrationOn() {
        return this.dbsToCancelMigrationOn;
    }

    public MigrationProperties withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        this.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
        return this;
    }

    public void validate() {
        if (this.currentStatus() != null) {
            this.currentStatus().validate();
        }
        if (this.sourceDbServerMetadata() != null) {
            this.sourceDbServerMetadata().validate();
        }
        if (this.targetDbServerMetadata() != null) {
            this.targetDbServerMetadata().validate();
        }
        if (this.secretParameters() != null) {
            this.secretParameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("migrationInstanceResourceId", this.migrationInstanceResourceId);
        jsonWriter.writeStringField("migrationMode", this.migrationMode == null ? null : this.migrationMode.toString());
        jsonWriter.writeStringField("migrationOption", this.migrationOption == null ? null : this.migrationOption.toString());
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        jsonWriter.writeStringField("sslMode", this.sslMode == null ? null : this.sslMode.toString());
        jsonWriter.writeStringField("sourceDbServerResourceId", this.sourceDbServerResourceId);
        jsonWriter.writeStringField("sourceDbServerFullyQualifiedDomainName", this.sourceDbServerFullyQualifiedDomainName);
        jsonWriter.writeStringField("targetDbServerFullyQualifiedDomainName", this.targetDbServerFullyQualifiedDomainName);
        jsonWriter.writeJsonField("secretParameters", (JsonSerializable)this.secretParameters);
        jsonWriter.writeArrayField("dbsToMigrate", this.dbsToMigrate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("setupLogicalReplicationOnSourceDbIfNeeded", this.setupLogicalReplicationOnSourceDbIfNeeded == null ? null : this.setupLogicalReplicationOnSourceDbIfNeeded.toString());
        jsonWriter.writeStringField("overwriteDbsInTarget", this.overwriteDbsInTarget == null ? null : this.overwriteDbsInTarget.toString());
        jsonWriter.writeStringField("migrationWindowStartTimeInUtc", this.migrationWindowStartTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowStartTimeInUtc));
        jsonWriter.writeStringField("migrationWindowEndTimeInUtc", this.migrationWindowEndTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowEndTimeInUtc));
        jsonWriter.writeStringField("migrateRoles", this.migrateRoles == null ? null : this.migrateRoles.toString());
        jsonWriter.writeStringField("startDataMigration", this.startDataMigration == null ? null : this.startDataMigration.toString());
        jsonWriter.writeStringField("triggerCutover", this.triggerCutover == null ? null : this.triggerCutover.toString());
        jsonWriter.writeArrayField("dbsToTriggerCutoverOn", this.dbsToTriggerCutoverOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cancel", this.cancel == null ? null : this.cancel.toString());
        jsonWriter.writeArrayField("dbsToCancelMigrationOn", this.dbsToCancelMigrationOn, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MigrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationProperties)jsonReader.readObject(reader -> {
            MigrationProperties deserializedMigrationProperties = new MigrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrationProperties.migrationId = reader.getString();
                    continue;
                }
                if ("currentStatus".equals(fieldName)) {
                    deserializedMigrationProperties.currentStatus = MigrationStatus.fromJson(reader);
                    continue;
                }
                if ("migrationInstanceResourceId".equals(fieldName)) {
                    deserializedMigrationProperties.migrationInstanceResourceId = reader.getString();
                    continue;
                }
                if ("migrationMode".equals(fieldName)) {
                    deserializedMigrationProperties.migrationMode = MigrationMode.fromString(reader.getString());
                    continue;
                }
                if ("migrationOption".equals(fieldName)) {
                    deserializedMigrationProperties.migrationOption = MigrationOption.fromString(reader.getString());
                    continue;
                }
                if ("sourceType".equals(fieldName)) {
                    deserializedMigrationProperties.sourceType = SourceType.fromString(reader.getString());
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedMigrationProperties.sslMode = SslMode.fromString(reader.getString());
                    continue;
                }
                if ("sourceDbServerMetadata".equals(fieldName)) {
                    deserializedMigrationProperties.sourceDbServerMetadata = DbServerMetadata.fromJson(reader);
                    continue;
                }
                if ("targetDbServerMetadata".equals(fieldName)) {
                    deserializedMigrationProperties.targetDbServerMetadata = DbServerMetadata.fromJson(reader);
                    continue;
                }
                if ("sourceDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationProperties.sourceDbServerResourceId = reader.getString();
                    continue;
                }
                if ("sourceDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationProperties.sourceDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("targetDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationProperties.targetDbServerResourceId = reader.getString();
                    continue;
                }
                if ("targetDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationProperties.targetDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("secretParameters".equals(fieldName)) {
                    deserializedMigrationProperties.secretParameters = MigrationSecretParameters.fromJson(reader);
                    continue;
                }
                if ("dbsToMigrate".equals(fieldName)) {
                    List dbsToMigrate;
                    deserializedMigrationProperties.dbsToMigrate = dbsToMigrate = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("setupLogicalReplicationOnSourceDbIfNeeded".equals(fieldName)) {
                    deserializedMigrationProperties.setupLogicalReplicationOnSourceDbIfNeeded = LogicalReplicationOnSourceServer.fromString(reader.getString());
                    continue;
                }
                if ("overwriteDbsInTarget".equals(fieldName)) {
                    deserializedMigrationProperties.overwriteDbsInTarget = OverwriteDatabasesOnTargetServer.fromString(reader.getString());
                    continue;
                }
                if ("migrationWindowStartTimeInUtc".equals(fieldName)) {
                    deserializedMigrationProperties.migrationWindowStartTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrationWindowEndTimeInUtc".equals(fieldName)) {
                    deserializedMigrationProperties.migrationWindowEndTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrateRoles".equals(fieldName)) {
                    deserializedMigrationProperties.migrateRoles = MigrateRolesAndPermissions.fromString(reader.getString());
                    continue;
                }
                if ("startDataMigration".equals(fieldName)) {
                    deserializedMigrationProperties.startDataMigration = StartDataMigration.fromString(reader.getString());
                    continue;
                }
                if ("triggerCutover".equals(fieldName)) {
                    deserializedMigrationProperties.triggerCutover = TriggerCutover.fromString(reader.getString());
                    continue;
                }
                if ("dbsToTriggerCutoverOn".equals(fieldName)) {
                    List dbsToTriggerCutoverOn;
                    deserializedMigrationProperties.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cancel".equals(fieldName)) {
                    deserializedMigrationProperties.cancel = Cancel.fromString(reader.getString());
                    continue;
                }
                if ("dbsToCancelMigrationOn".equals(fieldName)) {
                    List dbsToCancelMigrationOn;
                    deserializedMigrationProperties.dbsToCancelMigrationOn = dbsToCancelMigrationOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationProperties;
        });
    }
}

