/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationNameAvailabilityReason;
import java.io.IOException;

public final class MigrationNameAvailabilityInner
implements JsonSerializable<MigrationNameAvailabilityInner> {
    private String name;
    private String type;
    private Boolean nameAvailable;
    private MigrationNameAvailabilityReason reason;
    private String message;
    private static final ClientLogger LOGGER = new ClientLogger(MigrationNameAvailabilityInner.class);

    public String name() {
        return this.name;
    }

    public MigrationNameAvailabilityInner withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public MigrationNameAvailabilityInner withType(String type) {
        this.type = type;
        return this;
    }

    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    public MigrationNameAvailabilityReason reason() {
        return this.reason;
    }

    public String message() {
        return this.message;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MigrationNameAvailabilityInner"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model MigrationNameAvailabilityInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MigrationNameAvailabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationNameAvailabilityInner)jsonReader.readObject(reader -> {
            MigrationNameAvailabilityInner deserializedMigrationNameAvailabilityInner = new MigrationNameAvailabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMigrationNameAvailabilityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMigrationNameAvailabilityInner.type = reader.getString();
                    continue;
                }
                if ("nameAvailable".equals(fieldName)) {
                    deserializedMigrationNameAvailabilityInner.nameAvailable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedMigrationNameAvailabilityInner.reason = MigrationNameAvailabilityReason.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrationNameAvailabilityInner.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationNameAvailabilityInner;
        });
    }
}

