/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cancel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbServerMetadata;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesAndPermissions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDatabasesOnTargetServer;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SourceType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SslMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutover;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class MigrationInner
extends Resource {
    private MigrationProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private MigrationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public MigrationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public MigrationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String migrationId() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationId();
    }

    public MigrationStatus currentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().currentStatus();
    }

    public String migrationInstanceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationInstanceResourceId();
    }

    public MigrationInner withMigrationInstanceResourceId(String migrationInstanceResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withMigrationInstanceResourceId(migrationInstanceResourceId);
        return this;
    }

    public MigrationMode migrationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationMode();
    }

    public MigrationInner withMigrationMode(MigrationMode migrationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withMigrationMode(migrationMode);
        return this;
    }

    public MigrationOption migrationOption() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationOption();
    }

    public MigrationInner withMigrationOption(MigrationOption migrationOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withMigrationOption(migrationOption);
        return this;
    }

    public SourceType sourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceType();
    }

    public MigrationInner withSourceType(SourceType sourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withSourceType(sourceType);
        return this;
    }

    public SslMode sslMode() {
        return this.innerProperties() == null ? null : this.innerProperties().sslMode();
    }

    public MigrationInner withSslMode(SslMode sslMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withSslMode(sslMode);
        return this;
    }

    public DbServerMetadata sourceDbServerMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDbServerMetadata();
    }

    public DbServerMetadata targetDbServerMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDbServerMetadata();
    }

    public String sourceDbServerResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDbServerResourceId();
    }

    public MigrationInner withSourceDbServerResourceId(String sourceDbServerResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withSourceDbServerResourceId(sourceDbServerResourceId);
        return this;
    }

    public String sourceDbServerFullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDbServerFullyQualifiedDomainName();
    }

    public MigrationInner withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withSourceDbServerFullyQualifiedDomainName(sourceDbServerFullyQualifiedDomainName);
        return this;
    }

    public String targetDbServerResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDbServerResourceId();
    }

    public String targetDbServerFullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDbServerFullyQualifiedDomainName();
    }

    public MigrationInner withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withTargetDbServerFullyQualifiedDomainName(targetDbServerFullyQualifiedDomainName);
        return this;
    }

    public MigrationSecretParameters secretParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().secretParameters();
    }

    public MigrationInner withSecretParameters(MigrationSecretParameters secretParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withSecretParameters(secretParameters);
        return this;
    }

    public List<String> dbsToMigrate() {
        return this.innerProperties() == null ? null : this.innerProperties().dbsToMigrate();
    }

    public MigrationInner withDbsToMigrate(List<String> dbsToMigrate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withDbsToMigrate(dbsToMigrate);
        return this;
    }

    public LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.innerProperties() == null ? null : this.innerProperties().setupLogicalReplicationOnSourceDbIfNeeded();
    }

    public MigrationInner withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceServer setupLogicalReplicationOnSourceDbIfNeeded) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withSetupLogicalReplicationOnSourceDbIfNeeded(setupLogicalReplicationOnSourceDbIfNeeded);
        return this;
    }

    public OverwriteDatabasesOnTargetServer overwriteDbsInTarget() {
        return this.innerProperties() == null ? null : this.innerProperties().overwriteDbsInTarget();
    }

    public MigrationInner withOverwriteDbsInTarget(OverwriteDatabasesOnTargetServer overwriteDbsInTarget) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withOverwriteDbsInTarget(overwriteDbsInTarget);
        return this;
    }

    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationWindowStartTimeInUtc();
    }

    public MigrationInner withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withMigrationWindowStartTimeInUtc(migrationWindowStartTimeInUtc);
        return this;
    }

    public OffsetDateTime migrationWindowEndTimeInUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationWindowEndTimeInUtc();
    }

    public MigrationInner withMigrationWindowEndTimeInUtc(OffsetDateTime migrationWindowEndTimeInUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withMigrationWindowEndTimeInUtc(migrationWindowEndTimeInUtc);
        return this;
    }

    public MigrateRolesAndPermissions migrateRoles() {
        return this.innerProperties() == null ? null : this.innerProperties().migrateRoles();
    }

    public MigrationInner withMigrateRoles(MigrateRolesAndPermissions migrateRoles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withMigrateRoles(migrateRoles);
        return this;
    }

    public StartDataMigration startDataMigration() {
        return this.innerProperties() == null ? null : this.innerProperties().startDataMigration();
    }

    public MigrationInner withStartDataMigration(StartDataMigration startDataMigration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withStartDataMigration(startDataMigration);
        return this;
    }

    public TriggerCutover triggerCutover() {
        return this.innerProperties() == null ? null : this.innerProperties().triggerCutover();
    }

    public MigrationInner withTriggerCutover(TriggerCutover triggerCutover) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withTriggerCutover(triggerCutover);
        return this;
    }

    public List<String> dbsToTriggerCutoverOn() {
        return this.innerProperties() == null ? null : this.innerProperties().dbsToTriggerCutoverOn();
    }

    public MigrationInner withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withDbsToTriggerCutoverOn(dbsToTriggerCutoverOn);
        return this;
    }

    public Cancel cancel() {
        return this.innerProperties() == null ? null : this.innerProperties().cancel();
    }

    public MigrationInner withCancel(Cancel cancel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withCancel(cancel);
        return this;
    }

    public List<String> dbsToCancelMigrationOn() {
        return this.innerProperties() == null ? null : this.innerProperties().dbsToCancelMigrationOn();
    }

    public MigrationInner withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationProperties();
        }
        this.innerProperties().withDbsToCancelMigrationOn(dbsToCancelMigrationOn);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MigrationInner fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationInner)((Object)jsonReader.readObject(reader -> {
            MigrationInner deserializedMigrationInner = new MigrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMigrationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMigrationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMigrationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMigrationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMigrationInner.innerProperties = MigrationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMigrationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationInner;
        }));
    }
}

