/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HaMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SupportedFeature;
import java.io.IOException;
import java.util.List;

public final class ServerSkuCapability
extends CapabilityBase {
    private String name;
    private Integer vCores;
    private Integer supportedIops;
    private Long supportedMemoryPerVcoreMb;
    private List<String> supportedZones;
    private List<HaMode> supportedHaMode;
    private List<SupportedFeature> supportedFeatures;
    private String securityProfile;
    private String reason;
    private CapabilityStatus status;

    public String name() {
        return this.name;
    }

    public Integer vCores() {
        return this.vCores;
    }

    public Integer supportedIops() {
        return this.supportedIops;
    }

    public Long supportedMemoryPerVcoreMb() {
        return this.supportedMemoryPerVcoreMb;
    }

    public List<String> supportedZones() {
        return this.supportedZones;
    }

    public List<HaMode> supportedHaMode() {
        return this.supportedHaMode;
    }

    public List<SupportedFeature> supportedFeatures() {
        return this.supportedFeatures;
    }

    public String securityProfile() {
        return this.securityProfile;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.supportedFeatures() != null) {
            this.supportedFeatures().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ServerSkuCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ServerSkuCapability)jsonReader.readObject(reader -> {
            ServerSkuCapability deserializedServerSkuCapability = new ServerSkuCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedServerSkuCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedServerSkuCapability.reason = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerSkuCapability.name = reader.getString();
                    continue;
                }
                if ("vCores".equals(fieldName)) {
                    deserializedServerSkuCapability.vCores = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("supportedIops".equals(fieldName)) {
                    deserializedServerSkuCapability.supportedIops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("supportedMemoryPerVcoreMb".equals(fieldName)) {
                    deserializedServerSkuCapability.supportedMemoryPerVcoreMb = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("supportedZones".equals(fieldName)) {
                    List supportedZones;
                    deserializedServerSkuCapability.supportedZones = supportedZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("supportedHaMode".equals(fieldName)) {
                    List supportedHaMode;
                    deserializedServerSkuCapability.supportedHaMode = supportedHaMode = reader.readArray(reader1 -> HaMode.fromString(reader1.getString()));
                    continue;
                }
                if ("supportedFeatures".equals(fieldName)) {
                    List supportedFeatures;
                    deserializedServerSkuCapability.supportedFeatures = supportedFeatures = reader.readArray(reader1 -> SupportedFeature.fromJson(reader1));
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedServerSkuCapability.securityProfile = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerSkuCapability;
        });
    }
}

