/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RestartParameter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerForUpdate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServersClientImpl
implements ServersClient {
    private final ServersService service;
    private final PostgreSqlManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ServersClientImpl.class);

    ServersClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (ServersService)RestProxy.create(ServersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String serverName, ServerInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String serverName, ServerInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String serverName, ServerInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ServerInner>, ServerInner> beginCreateAsync(String resourceGroupName, String serverName, ServerInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ServerInner.class), (Type)((Object)ServerInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerInner>, ServerInner> beginCreate(String resourceGroupName, String serverName, ServerInner parameters) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(response, (Type)((Object)ServerInner.class), (Type)((Object)ServerInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerInner>, ServerInner> beginCreate(String resourceGroupName, String serverName, ServerInner parameters, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, serverName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)ServerInner.class), (Type)((Object)ServerInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerInner> createAsync(String resourceGroupName, String serverName, ServerInner parameters) {
        return this.beginCreateAsync(resourceGroupName, serverName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerInner create(String resourceGroupName, String serverName, ServerInner parameters) {
        return (ServerInner)((Object)this.beginCreate(resourceGroupName, serverName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerInner create(String resourceGroupName, String serverName, ServerInner parameters, Context context) {
        return (ServerInner)((Object)this.beginCreate(resourceGroupName, serverName, parameters, context).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, ServerForUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String serverName, ServerForUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String serverName, ServerForUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ServerInner>, ServerInner> beginUpdateAsync(String resourceGroupName, String serverName, ServerForUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ServerInner.class), (Type)((Object)ServerInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerInner>, ServerInner> beginUpdate(String resourceGroupName, String serverName, ServerForUpdate parameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(response, (Type)((Object)ServerInner.class), (Type)((Object)ServerInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerInner>, ServerInner> beginUpdate(String resourceGroupName, String serverName, ServerForUpdate parameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, serverName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)ServerInner.class), (Type)((Object)ServerInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerInner> updateAsync(String resourceGroupName, String serverName, ServerForUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, serverName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerInner update(String resourceGroupName, String serverName, ServerForUpdate parameters) {
        return (ServerInner)((Object)this.beginUpdate(resourceGroupName, serverName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerInner update(String resourceGroupName, String serverName, ServerForUpdate parameters, Context context) {
        return (ServerInner)((Object)this.beginUpdate(resourceGroupName, serverName, parameters, context).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, serverName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, serverName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName) {
        return this.beginDeleteAsync(resourceGroupName, serverName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName) {
        this.beginDelete(resourceGroupName, serverName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, Context context) {
        this.beginDelete(resourceGroupName, serverName, context).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ServerInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerInner> getByResourceGroupAsync(String resourceGroupName, String serverName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, serverName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ServerInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerInner> getByResourceGroupWithResponse(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerInner getByResourceGroup(String resourceGroupName, String serverName) {
        return (ServerInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, serverName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ServerInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listByResourceGroupSinglePage(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ServerInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String serverName, RestartParameter parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restartWithResponse(String resourceGroupName, String serverName, RestartParameter parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        return this.service.restartSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restartWithResponse(String resourceGroupName, String serverName, RestartParameter parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        return this.service.restartSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String serverName, RestartParameter parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String serverName) {
        RestartParameter parameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String serverName, RestartParameter parameters) {
        Response<BinaryData> response = this.restartWithResponse(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String serverName) {
        RestartParameter parameters = null;
        Response<BinaryData> response = this.restartWithResponse(resourceGroupName, serverName, parameters);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String serverName, RestartParameter parameters, Context context) {
        Response<BinaryData> response = this.restartWithResponse(resourceGroupName, serverName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String serverName, RestartParameter parameters) {
        return this.beginRestartAsync(resourceGroupName, serverName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String serverName) {
        RestartParameter parameters = null;
        return this.beginRestartAsync(resourceGroupName, serverName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String serverName) {
        RestartParameter parameters = null;
        this.beginRestart(resourceGroupName, serverName, parameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String serverName, RestartParameter parameters, Context context) {
        this.beginRestart(resourceGroupName, serverName, parameters, context).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startWithResponse(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.startSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startWithResponse(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.startSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String serverName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, serverName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String serverName) {
        Response<BinaryData> response = this.startWithResponse(resourceGroupName, serverName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String serverName, Context context) {
        Response<BinaryData> response = this.startWithResponse(resourceGroupName, serverName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String resourceGroupName, String serverName) {
        return this.beginStartAsync(resourceGroupName, serverName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String serverName) {
        this.beginStart(resourceGroupName, serverName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String resourceGroupName, String serverName, Context context) {
        this.beginStart(resourceGroupName, serverName, context).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> stopWithResponse(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.stopSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> stopWithResponse(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.stopSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStopAsync(String resourceGroupName, String serverName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, serverName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String serverName) {
        Response<BinaryData> response = this.stopWithResponse(resourceGroupName, serverName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStop(String resourceGroupName, String serverName, Context context) {
        Response<BinaryData> response = this.stopWithResponse(resourceGroupName, serverName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopAsync(String resourceGroupName, String serverName) {
        return this.beginStopAsync(resourceGroupName, serverName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String serverName) {
        this.beginStop(resourceGroupName, serverName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String serverName, Context context) {
        this.beginStop(resourceGroupName, serverName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listByResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ServerInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ServerListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServerListResult)res.getValue()).value(), ((ServerListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface ServersService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") ServerInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") ServerInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") ServerForUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") ServerForUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ServerInner> getByResourceGroupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ServerListResult> listByResourceGroupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/flexibleServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/flexibleServers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ServerListResult> listSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") RestartParameter var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> restartSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @BodyParam(value="application/json") RestartParameter var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> startSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> stop(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> stopSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ServerListResult> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ServerListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

