/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PrivateEndpointConnectionOperationsClientImpl
implements PrivateEndpointConnectionOperationsClient {
    private final PrivateEndpointConnectionOperationsService service;
    private final PostgreSqlManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionOperationsClientImpl.class);

    PrivateEndpointConnectionOperationsClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (PrivateEndpointConnectionOperationsService)RestProxy.create(PrivateEndpointConnectionOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, privateEndpointConnectionName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, privateEndpointConnectionName, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, privateEndpointConnectionName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, privateEndpointConnectionName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdate(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, serverName, privateEndpointConnectionName, parameters);
        return this.client.getLroResult(response, (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner> beginUpdate(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, serverName, privateEndpointConnectionName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)PrivateEndpointConnectionInner.class), (Type)((Object)PrivateEndpointConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, serverName, privateEndpointConnectionName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner update(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return (PrivateEndpointConnectionInner)((Object)this.beginUpdate(resourceGroupName, serverName, privateEndpointConnectionName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateEndpointConnectionInner update(String resourceGroupName, String serverName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, Context context) {
        return (PrivateEndpointConnectionInner)((Object)this.beginUpdate(resourceGroupName, serverName, privateEndpointConnectionName, parameters, context).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, privateEndpointConnectionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, privateEndpointConnectionName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String serverName, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, privateEndpointConnectionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, privateEndpointConnectionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, serverName, privateEndpointConnectionName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String privateEndpointConnectionName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, serverName, privateEndpointConnectionName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, privateEndpointConnectionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        this.beginDelete(resourceGroupName, serverName, privateEndpointConnectionName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String privateEndpointConnectionName, Context context) {
        this.beginDelete(resourceGroupName, serverName, privateEndpointConnectionName, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface PrivateEndpointConnectionOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @BodyParam(value="application/json") PrivateEndpointConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @BodyParam(value="application/json") PrivateEndpointConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="privateEndpointConnectionName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

