/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ActiveDirectoryAdministratorInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ActiveDirectoryAdministrator;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ActiveDirectoryAdministratorAdd;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrincipalType;

public final class ActiveDirectoryAdministratorImpl
implements ActiveDirectoryAdministrator,
ActiveDirectoryAdministrator.Definition {
    private ActiveDirectoryAdministratorInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String objectId;
    private ActiveDirectoryAdministratorAdd createParameters;

    ActiveDirectoryAdministratorImpl(ActiveDirectoryAdministratorInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public PrincipalType principalType() {
        return this.innerModel().principalType();
    }

    @Override
    public String principalName() {
        return this.innerModel().principalName();
    }

    @Override
    public String objectId() {
        return this.innerModel().objectId();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public ActiveDirectoryAdministratorInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ActiveDirectoryAdministratorImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public ActiveDirectoryAdministrator create() {
        this.innerObject = this.serviceManager.serviceClient().getAdministrators().create(this.resourceGroupName, this.serverName, this.objectId, this.createParameters, Context.NONE);
        return this;
    }

    @Override
    public ActiveDirectoryAdministrator create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAdministrators().create(this.resourceGroupName, this.serverName, this.objectId, this.createParameters, context);
        return this;
    }

    ActiveDirectoryAdministratorImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new ActiveDirectoryAdministratorInner();
        this.serviceManager = serviceManager;
        this.objectId = name;
        this.createParameters = new ActiveDirectoryAdministratorAdd();
    }

    @Override
    public ActiveDirectoryAdministrator refresh() {
        this.innerObject = (ActiveDirectoryAdministratorInner)((Object)this.serviceManager.serviceClient().getAdministrators().getWithResponse(this.resourceGroupName, this.serverName, this.objectId, Context.NONE).getValue());
        return this;
    }

    @Override
    public ActiveDirectoryAdministrator refresh(Context context) {
        this.innerObject = (ActiveDirectoryAdministratorInner)((Object)this.serviceManager.serviceClient().getAdministrators().getWithResponse(this.resourceGroupName, this.serverName, this.objectId, context).getValue());
        return this;
    }

    @Override
    public ActiveDirectoryAdministratorImpl withPrincipalType(PrincipalType principalType) {
        this.createParameters.withPrincipalType(principalType);
        return this;
    }

    @Override
    public ActiveDirectoryAdministratorImpl withPrincipalName(String principalName) {
        this.createParameters.withPrincipalName(principalName);
        return this;
    }

    @Override
    public ActiveDirectoryAdministratorImpl withTenantId(String tenantId) {
        this.createParameters.withTenantId(tenantId);
        return this;
    }
}

