/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ImpactRecord;
import com.azure.resourcemanager.postgresqlflexibleserver.models.IndexRecommendationDetails;
import com.azure.resourcemanager.postgresqlflexibleserver.models.IndexRecommendationResourcePropertiesAnalyzedWorkload;
import com.azure.resourcemanager.postgresqlflexibleserver.models.IndexRecommendationResourcePropertiesImplementationDetails;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RecommendationTypeEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class IndexRecommendationResourceProperties
implements JsonSerializable<IndexRecommendationResourceProperties> {
    private OffsetDateTime initialRecommendedTime;
    private OffsetDateTime lastRecommendedTime;
    private Integer timesRecommended;
    private List<Long> improvedQueryIds;
    private String recommendationReason;
    private RecommendationTypeEnum recommendationType;
    private IndexRecommendationResourcePropertiesImplementationDetails implementationDetails;
    private IndexRecommendationResourcePropertiesAnalyzedWorkload analyzedWorkload;
    private List<ImpactRecord> estimatedImpact;
    private IndexRecommendationDetails details;

    public OffsetDateTime initialRecommendedTime() {
        return this.initialRecommendedTime;
    }

    public IndexRecommendationResourceProperties withInitialRecommendedTime(OffsetDateTime initialRecommendedTime) {
        this.initialRecommendedTime = initialRecommendedTime;
        return this;
    }

    public OffsetDateTime lastRecommendedTime() {
        return this.lastRecommendedTime;
    }

    public IndexRecommendationResourceProperties withLastRecommendedTime(OffsetDateTime lastRecommendedTime) {
        this.lastRecommendedTime = lastRecommendedTime;
        return this;
    }

    public Integer timesRecommended() {
        return this.timesRecommended;
    }

    public IndexRecommendationResourceProperties withTimesRecommended(Integer timesRecommended) {
        this.timesRecommended = timesRecommended;
        return this;
    }

    public List<Long> improvedQueryIds() {
        return this.improvedQueryIds;
    }

    public IndexRecommendationResourceProperties withImprovedQueryIds(List<Long> improvedQueryIds) {
        this.improvedQueryIds = improvedQueryIds;
        return this;
    }

    public String recommendationReason() {
        return this.recommendationReason;
    }

    public IndexRecommendationResourceProperties withRecommendationReason(String recommendationReason) {
        this.recommendationReason = recommendationReason;
        return this;
    }

    public RecommendationTypeEnum recommendationType() {
        return this.recommendationType;
    }

    public IndexRecommendationResourceProperties withRecommendationType(RecommendationTypeEnum recommendationType) {
        this.recommendationType = recommendationType;
        return this;
    }

    public IndexRecommendationResourcePropertiesImplementationDetails implementationDetails() {
        return this.implementationDetails;
    }

    public IndexRecommendationResourceProperties withImplementationDetails(IndexRecommendationResourcePropertiesImplementationDetails implementationDetails) {
        this.implementationDetails = implementationDetails;
        return this;
    }

    public IndexRecommendationResourcePropertiesAnalyzedWorkload analyzedWorkload() {
        return this.analyzedWorkload;
    }

    public IndexRecommendationResourceProperties withAnalyzedWorkload(IndexRecommendationResourcePropertiesAnalyzedWorkload analyzedWorkload) {
        this.analyzedWorkload = analyzedWorkload;
        return this;
    }

    public List<ImpactRecord> estimatedImpact() {
        return this.estimatedImpact;
    }

    public IndexRecommendationDetails details() {
        return this.details;
    }

    public void validate() {
        if (this.implementationDetails() != null) {
            this.implementationDetails().validate();
        }
        if (this.analyzedWorkload() != null) {
            this.analyzedWorkload().validate();
        }
        if (this.estimatedImpact() != null) {
            this.estimatedImpact().forEach(e -> e.validate());
        }
        if (this.details() != null) {
            this.details().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("initialRecommendedTime", this.initialRecommendedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.initialRecommendedTime));
        jsonWriter.writeStringField("lastRecommendedTime", this.lastRecommendedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastRecommendedTime));
        jsonWriter.writeNumberField("timesRecommended", (Number)this.timesRecommended);
        jsonWriter.writeArrayField("improvedQueryIds", this.improvedQueryIds, (writer, element) -> writer.writeLong(element.longValue()));
        jsonWriter.writeStringField("recommendationReason", this.recommendationReason);
        jsonWriter.writeStringField("recommendationType", this.recommendationType == null ? null : this.recommendationType.toString());
        jsonWriter.writeJsonField("implementationDetails", (JsonSerializable)this.implementationDetails);
        jsonWriter.writeJsonField("analyzedWorkload", (JsonSerializable)this.analyzedWorkload);
        return jsonWriter.writeEndObject();
    }

    public static IndexRecommendationResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IndexRecommendationResourceProperties)jsonReader.readObject(reader -> {
            IndexRecommendationResourceProperties deserializedIndexRecommendationResourceProperties = new IndexRecommendationResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("initialRecommendedTime".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.initialRecommendedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastRecommendedTime".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.lastRecommendedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timesRecommended".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.timesRecommended = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("improvedQueryIds".equals(fieldName)) {
                    List improvedQueryIds;
                    deserializedIndexRecommendationResourceProperties.improvedQueryIds = improvedQueryIds = reader.readArray(reader1 -> reader1.getLong());
                    continue;
                }
                if ("recommendationReason".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.recommendationReason = reader.getString();
                    continue;
                }
                if ("recommendationType".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.recommendationType = RecommendationTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("implementationDetails".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.implementationDetails = IndexRecommendationResourcePropertiesImplementationDetails.fromJson(reader);
                    continue;
                }
                if ("analyzedWorkload".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.analyzedWorkload = IndexRecommendationResourcePropertiesAnalyzedWorkload.fromJson(reader);
                    continue;
                }
                if ("estimatedImpact".equals(fieldName)) {
                    List estimatedImpact;
                    deserializedIndexRecommendationResourceProperties.estimatedImpact = estimatedImpact = reader.readArray(reader1 -> ImpactRecord.fromJson(reader1));
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedIndexRecommendationResourceProperties.details = IndexRecommendationDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIndexRecommendationResourceProperties;
        });
    }
}

