/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.playwrighttesting.PlaywrightTestingManager;
import com.azure.resourcemanager.playwrighttesting.fluent.QuotasClient;
import com.azure.resourcemanager.playwrighttesting.fluent.models.QuotaInner;
import com.azure.resourcemanager.playwrighttesting.implementation.QuotaImpl;
import com.azure.resourcemanager.playwrighttesting.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwrighttesting.models.Quota;
import com.azure.resourcemanager.playwrighttesting.models.QuotaNames;
import com.azure.resourcemanager.playwrighttesting.models.Quotas;

public final class QuotasImpl
implements Quotas {
    private static final ClientLogger LOGGER = new ClientLogger(QuotasImpl.class);
    private final QuotasClient innerClient;
    private final PlaywrightTestingManager serviceManager;

    public QuotasImpl(QuotasClient innerClient, PlaywrightTestingManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Quota> getWithResponse(String location, QuotaNames quotaName, Context context) {
        Response<QuotaInner> inner = this.serviceClient().getWithResponse(location, quotaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QuotaImpl((QuotaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Quota get(String location, QuotaNames quotaName) {
        QuotaInner inner = this.serviceClient().get(location, quotaName);
        if (inner != null) {
            return new QuotaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Quota> listBySubscription(String location) {
        PagedIterable<QuotaInner> inner = this.serviceClient().listBySubscription(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new QuotaImpl((QuotaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Quota> listBySubscription(String location, Context context) {
        PagedIterable<QuotaInner> inner = this.serviceClient().listBySubscription(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new QuotaImpl((QuotaInner)((Object)inner1), this.manager()));
    }

    private QuotasClient serviceClient() {
        return this.innerClient;
    }

    private PlaywrightTestingManager manager() {
        return this.serviceManager;
    }
}

