/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.playwrighttesting.PlaywrightTestingManager;
import com.azure.resourcemanager.playwrighttesting.fluent.models.AccountInner;
import com.azure.resourcemanager.playwrighttesting.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwrighttesting.models.Account;
import com.azure.resourcemanager.playwrighttesting.models.AccountProperties;
import com.azure.resourcemanager.playwrighttesting.models.AccountUpdate;
import com.azure.resourcemanager.playwrighttesting.models.AccountUpdateProperties;
import java.util.Collections;
import java.util.Map;

public final class AccountImpl
implements Account,
Account.Definition,
Account.Update {
    private AccountInner innerObject;
    private final PlaywrightTestingManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private AccountUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public AccountProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AccountInner innerModel() {
        return this.innerObject;
    }

    private PlaywrightTestingManager manager() {
        return this.serviceManager;
    }

    @Override
    public AccountImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Account create() {
        this.innerObject = this.serviceManager.serviceClient().getAccounts().createOrUpdate(this.resourceGroupName, this.accountName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Account create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAccounts().createOrUpdate(this.resourceGroupName, this.accountName, this.innerModel(), context);
        return this;
    }

    AccountImpl(String name, PlaywrightTestingManager serviceManager) {
        this.innerObject = new AccountInner();
        this.serviceManager = serviceManager;
        this.accountName = name;
    }

    @Override
    public AccountImpl update() {
        this.updateProperties = new AccountUpdate();
        return this;
    }

    @Override
    public Account apply() {
        this.innerObject = (AccountInner)((Object)this.serviceManager.serviceClient().getAccounts().updateWithResponse(this.resourceGroupName, this.accountName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public Account apply(Context context) {
        this.innerObject = (AccountInner)((Object)this.serviceManager.serviceClient().getAccounts().updateWithResponse(this.resourceGroupName, this.accountName, this.updateProperties, context).getValue());
        return this;
    }

    AccountImpl(AccountInner innerObject, PlaywrightTestingManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "accounts");
    }

    @Override
    public Account refresh() {
        this.innerObject = (AccountInner)((Object)this.serviceManager.serviceClient().getAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Account refresh(Context context) {
        this.innerObject = (AccountInner)((Object)this.serviceManager.serviceClient().getAccounts().getByResourceGroupWithResponse(this.resourceGroupName, this.accountName, context).getValue());
        return this;
    }

    @Override
    public AccountImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AccountImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AccountImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public AccountImpl withProperties(AccountProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public AccountImpl withProperties(AccountUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

