/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.models.QuotaProperties;
import java.io.IOException;

public final class QuotaInner
extends ProxyResource {
    private QuotaProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private QuotaInner() {
    }

    public QuotaProperties properties() {
        return this.properties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static QuotaInner fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaInner)((Object)jsonReader.readObject(reader -> {
            QuotaInner deserializedQuotaInner = new QuotaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedQuotaInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedQuotaInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedQuotaInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedQuotaInner.properties = QuotaProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedQuotaInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaInner;
        }));
    }
}

