/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightQuotaInner;
import java.io.IOException;
import java.util.List;

public final class PlaywrightQuotaListResult
implements JsonSerializable<PlaywrightQuotaListResult> {
    private List<PlaywrightQuotaInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(PlaywrightQuotaListResult.class);

    private PlaywrightQuotaListResult() {
    }

    public List<PlaywrightQuotaInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model PlaywrightQuotaListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static PlaywrightQuotaListResult fromJson(JsonReader jsonReader) throws IOException {
        return (PlaywrightQuotaListResult)jsonReader.readObject(reader -> {
            PlaywrightQuotaListResult deserializedPlaywrightQuotaListResult = new PlaywrightQuotaListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedPlaywrightQuotaListResult.value = value = reader.readArray(reader1 -> PlaywrightQuotaInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedPlaywrightQuotaListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlaywrightQuotaListResult;
        });
    }
}

