/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwright.models.EnablementStatus;
import com.azure.resourcemanager.playwright.models.ProvisioningState;
import java.io.IOException;

public final class PlaywrightWorkspaceProperties
implements JsonSerializable<PlaywrightWorkspaceProperties> {
    private ProvisioningState provisioningState;
    private String dataplaneUri;
    private EnablementStatus regionalAffinity;
    private EnablementStatus localAuth;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String dataplaneUri() {
        return this.dataplaneUri;
    }

    public EnablementStatus regionalAffinity() {
        return this.regionalAffinity;
    }

    public PlaywrightWorkspaceProperties withRegionalAffinity(EnablementStatus regionalAffinity) {
        this.regionalAffinity = regionalAffinity;
        return this;
    }

    public EnablementStatus localAuth() {
        return this.localAuth;
    }

    public PlaywrightWorkspaceProperties withLocalAuth(EnablementStatus localAuth) {
        this.localAuth = localAuth;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("regionalAffinity", this.regionalAffinity == null ? null : this.regionalAffinity.toString());
        jsonWriter.writeStringField("localAuth", this.localAuth == null ? null : this.localAuth.toString());
        return jsonWriter.writeEndObject();
    }

    public static PlaywrightWorkspaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PlaywrightWorkspaceProperties)jsonReader.readObject(reader -> {
            PlaywrightWorkspaceProperties deserializedPlaywrightWorkspaceProperties = new PlaywrightWorkspaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("dataplaneUri".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceProperties.dataplaneUri = reader.getString();
                    continue;
                }
                if ("regionalAffinity".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceProperties.regionalAffinity = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("localAuth".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceProperties.localAuth = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlaywrightWorkspaceProperties;
        });
    }
}

